% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_CompareFiles.R
\name{CompareFiles}
\alias{CompareFiles}
\title{Compare HYPE model files to identify any differences.}
\usage{
CompareFiles(x, y, type, by = NULL, compare.order = TRUE, ...)
}
\arguments{
\item{x}{Path to a HYPE model file to read, or an existing list/data frame object for a HYPE model file.
File contents are compared to those of \code{y}.}

\item{y}{Path to a HYPE model file to read, or an existing list/data frame object for a HYPE model file.
File contents are compared to those of \code{x}.}

\item{type}{Character string identifying the type of HYPE model file. Used to determine appropriate read function. One of
\code{AquiferData}, \code{BasinOutput}, \code{BranchData}, \code{CropData}, \code{DamData}, \code{ForcKey}, \code{GeoClass},
\code{GeoData}, \code{Info}, \code{LakeData}, \code{MapOutput}, \code{MgmtData}, \code{Optpar}, \code{Par}, \code{PointSourceData}, \code{Obs},
\code{Simass}, \code{Subass}, \code{TimeOutput}, or \code{Xobs}.}

\item{by}{Character vector, names of columns in \code{x} and \code{y} to use to join data. See \code{\link[dplyr:mutate-joins]{dplyr::full_join()}}.}

\item{compare.order}{Logical, whether or not the order of the rows should be compared. If \code{TRUE}, then \code{x} and \code{y}
will also be joined by row number. See \code{\link{full_join}}.}

\item{...}{Other arguments passed on to functions to read the files to compare (e.g. \code{\link{ReadGeoData}}, \code{\link{ReadPar}}, etc.).}
}
\value{
Returns invisibly a data frame containing rows and columns in which differences exist between \code{x} and \code{y}. Values that are the same in both
files are set to \code{NA}. If the returned data frame has 0 row, then there were no differences between the files.
}
\description{
Compare HYPE model files to identify any differences, typically used to check that no undesired changes were made when writing a new file.
}
\details{
\code{CompareFiles} compares two HYPE model files and identifies any differences in values. The function reads two model files, compares
the values in columns with corresponding names, and returns a data frame consisting of rows/columns with any differences. Values that are
the same in both files are set to \code{NA}. The function is primarily intended as a check to ensure that no unintended changes were made when writing
model files using the various HYPEtools write functions. However, it can also be used to e.g. compare files between different model versions.
}
\examples{
# Import demo model GeoData file, edit a SUBID
te1 <- ReadGeoData(filename = system.file("demo_model", "GeoData.txt", package = "HYPEtools"))
te1$SUBID[1] <- 1
# Compare with original file
te2 <- CompareFiles(system.file("demo_model", "GeoData.txt", package = "HYPEtools"), te1, 
                    type = "GeoData")
te2

}
