% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xcountCutoff.R
\name{xcountCutoff}
\alias{xcountCutoff}
\title{Determine immediately whether number of tables is over a limit}
\usage{
xcountCutoff(m, cutoff = 1e+07)
}
\arguments{
\item{m}{vector containing the numbers of alleles of each type. It can also be a matrix of genotype counts, but not a vector of genotype counts.}

\item{cutoff}{Is the number of tables above or below this value?}
}
\value{
TRUE or FALSE depending on whether the table count is above or below \code{cutoff}
}
\description{
Calling \code{scountCutoff} gives you a quick answer to whether the number of tables is over a given cutoff. It is useful in deciding whether to analyze a data set with \code{\link{xtest}} or \code{\link{mtest}}. This function is used by \code{\link{hwx.test}} and not normally called directly by the user.
}
\examples{
#
alleles <- c(15, 14, 11, 12, 2, 2, 1, 3)
if(xcountCutoff(alleles)) cat("There are too many tables")
}

