#' Atlantic HURDAT
#'
#' HURDAT dataset for the Atlantic basin.
#'
#' @format A dataframe with 21 variables.
#' \describe{
#'      \item{\code{Key}}{Unique key identifying the tropical cyclone.
#'          Formatted like AABBCCCC where AA is Basin, BB is YearNum and CC is
#'          Year}
#'      \item{\code{Name}}{Name of the storm (UNNAMED for early storms)}
#'      \item{\code{DateTime}}{Date and time of observation in UTC, POSIXct}
#'      \item{\code{Record}}{Record identifier:
#'          \describe{
#'              \item{\code{C}}{Closest approach to a coast, not followed
#'                  by a landfall.}
#'              \item{\code{G}}{Genesis.}
#'              \item{\code{I}}{An intensity peak in terms of both pressure
#'                  and wind.}
#'              \item{\code{L}}{Landfall (center of system crossing a
#'                  coastline).}
#'              \item{\code{P}}{Minimum central pressure.}
#'              \item{\code{R}}{Provides additional detail on the intensity
#'                  of the cyclone when rapid changes are underway.}
#'              \item{\code{S}}{Change of status of the system.}
#'              \item{\code{T}}{Provides additional detail on the track.}
#'              \item{\code{W}}{Maximum sustained wind speed.}
#'          }
#'      }
#'      \item{\code{Status}}{Status of the system:
#'          \describe{
#'              \item{\code{TD}}{Tropical depression (winds < 34 kts)}
#'              \item{\code{TS}}{Tropical storm (winds 34-63 kts)}
#'              \item{\code{HU}}{Hurricane (winds >= 64 kts)}
#'              \item{\code{EX}}{Extratropical cyclone of any intensity}
#'              \item{\code{SD}}{Subtropical cyclone of subtropical depression
#'                  intensity (winds < 34 kts).}
#'              \item{\code{SS}}{Subtroipcal cyclone of subtropical cyclone
#'                  intensity (winds >= 34 kts)}
#'              \item{\code{LO}}{A low that is neither a tropical cyclone,
#'                  subtropical cyclone nor extratropical of any intensity.}
#'              \item{\code{WV}}{Tropical wave}
#'              \item{\code{DB}}{Tropical disturbance}
#'          }
#'      }
#'      \item{\code{Lat}}{Latitude position; >0 for northern hemisphere,
#'          <0 for southern hemisphere.}
#'      \item{\code{Lon}}{Longitude position; >0 for eastern hemisphere,
#'          <0 for western hemisphere.}
#'      \item{\code{Wind}}{Recorded or estimated wind speed in knots}
#'      \item{\code{Pressure}}{Recorded or estimated central pressure in
#'          millibars}
#'      \item{\code{NE34}}{Radius of winds > 34 kts in the
#'          northeastern quadrant.}
#'      \item{\code{SE34}}{Radius of winds > 34 kts in the
#'          southeastern quadrant.}
#'      \item{\code{SW34}}{Radius of winds > 34 kts in the
#'          southwestern quadrant.}
#'      \item{\code{NW34}}{Radius of winds > 34 kts in the
#'          northwestern quadrant.}
#'      \item{\code{NE50}}{Radius of winds > 50 kts in the
#'          northeastern quadrant.}
#'      \item{\code{SE50}}{Radius of winds > 50 kts in the
#'          southeastern quadrant.}
#'      \item{\code{SW50}}{Radius of winds > 50 kts in the
#'          southwestern quadrant.}
#'      \item{\code{NW50}}{Radius of winds > 50 kts in the
#'          northwestern quadrant.}
#'      \item{\code{NE64}}{Radius of winds > 64 kts in the
#'          northeastern quadrant.}
#'      \item{\code{SE64}}{Radius of winds > 64 kts in the
#'          southeastern quadrant.}
#'      \item{\code{SW64}}{Radius of winds > 64 kts in the
#'          southwestern quadrant.}
#'      \item{\code{NW64}}{Radius of winds > 64 kts in the
#'          northwestern quadrant.}
#' }
#'
"AL"

#' Eastern and Central Pacific HURDAT
#'
#' HURDAT dataset for the northeastern and central Pacific basin.
#'
#' @format A dataframe with 21 variables.
#' \describe{
#'      \item{\code{Key}}{Unique key identifying the tropical cyclone.
#'          Formatted like AABBCCCC where AA is Basin, BB is YearNum and CC is
#'          Year}
#'      \item{\code{Name}}{Name of the storm (UNNAMED for early storms)}
#'      \item{\code{DateTime}}{Date and time of observation in UTC, POSIXct}
#'      \item{\code{Record}}{Record identifier:
#'          \describe{
#'              \item{\code{C}}{Closest approach to a coast, not followed
#'                  by a landfall.}
#'              \item{\code{G}}{Genesis.}
#'              \item{\code{I}}{An intensity peak in terms of both pressure
#'                  and wind.}
#'              \item{\code{L}}{Landfall (center of system crossing a
#'                  coastline).}
#'              \item{\code{P}}{Minimum central pressure.}
#'              \item{\code{R}}{Provides additional detail on the intensity
#'                  of the cyclone when rapid changes are underway.}
#'              \item{\code{S}}{Change of status of the system.}
#'              \item{\code{T}}{Provides additional detail on the track.}
#'              \item{\code{W}}{Maximum sustained wind speed.}
#'          }
#'      }
#'      \item{\code{Status}}{Status of the system:
#'          \describe{
#'              \item{\code{TD}}{Tropical depression (winds < 34 kts)}
#'              \item{\code{TS}}{Tropical storm (winds 34-63 kts)}
#'              \item{\code{HU}}{Hurricane (winds >= 64 kts)}
#'              \item{\code{EX}}{Extratropical cyclone of any intensity}
#'              \item{\code{SD}}{Subtropical cyclone of subtropical depression
#'                  intensity (winds < 34 kts).}
#'              \item{\code{SS}}{Subtroipcal cyclone of subtropical cyclone
#'                  intensity (winds >= 34 kts)}
#'              \item{\code{LO}}{A low that is neither a tropical cyclone,
#'                  subtropical cyclone nor extratropical of any intensity.}
#'              \item{\code{WV}}{Tropical wave}
#'              \item{\code{DB}}{Tropical disturbance}
#'          }
#'      }
#'      \item{\code{Lat}}{Latitude position; >0 for northern hemisphere,
#'          <0 for southern hemisphere.}
#'      \item{\code{Lon}}{Longitude position; >0 for eastern hemisphere,
#'          <0 for western hemisphere.}
#'      \item{\code{Wind}}{Recorded or estimated wind speed in knots}
#'      \item{\code{Pressure}}{Recorded or estimated central pressure in
#'          millibars}
#'      \item{\code{NE34}}{Radius of winds > 34 kts in the
#'          northeastern quadrant.}
#'      \item{\code{SE34}}{Radius of winds > 34 kts in the
#'          southeastern quadrant.}
#'      \item{\code{SW34}}{Radius of winds > 34 kts in the
#'          southwestern quadrant.}
#'      \item{\code{NW34}}{Radius of winds > 34 kts in the
#'          northwestern quadrant.}
#'      \item{\code{NE50}}{Radius of winds > 50 kts in the
#'          northeastern quadrant.}
#'      \item{\code{SE50}}{Radius of winds > 50 kts in the
#'          southeastern quadrant.}
#'      \item{\code{SW50}}{Radius of winds > 50 kts in the
#'          southwestern quadrant.}
#'      \item{\code{NW50}}{Radius of winds > 50 kts in the
#'          northwestern quadrant.}
#'      \item{\code{NE64}}{Radius of winds > 64 kts in the
#'          northeastern quadrant.}
#'      \item{\code{SE64}}{Radius of winds > 64 kts in the
#'          southeastern quadrant.}
#'      \item{\code{SW64}}{Radius of winds > 64 kts in the
#'          southwestern quadrant.}
#'      \item{\code{NW64}}{Radius of winds > 64 kts in the
#'          northwestern quadrant.}
#' }
#'
"EP"
