% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BD_ordinations.R
\name{physeq_list_ord}
\alias{physeq_list_ord}
\title{calculating ordinations from a list of distance matrices}
\usage{
physeq_list_ord(physeq_l, physeq_l_d, ord_method = "NMDS")
}
\arguments{
\item{physeq_l}{A list of phyloseq objects}

\item{physeq_l_d}{A list of dist objects}

\item{ord_method}{See phyloseq::ordinate}
}
\value{
List of ordination objects
}
\description{
For each \code{dist} object in a provided list, the fucntion
calculates an ordination with the \code{phyloseq::ordinate} function.
}
\examples{
data(physeq_S2D2_l)
\dontrun{
# make a list of beta diversity distance matrix objects
physeq_S2D2_l_d = physeq_list_betaDiv(physeq_S2D2_l)
# make a list of ordinations
physeq_S2D2_l_d_ord = physeq_list_ord(physeq_S2D2_l, physeq_S2D2_l_d)
}

}
