% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyloseq_subset.R
\name{expr_param_extract}
\alias{expr_param_extract}
\title{Extract all quoted values in the expression used for phyloseq subsetting.}
\usage{
expr_param_extract(ex, collapse = NULL)
}
\arguments{
\item{ex}{Expression for subsetting the phyloseq object}

\item{collapse}{Similar to the collapse parameter in \code{base::paste}}
}
\value{
If \code{length(ex) == 1}, then a vector of quoted values in the input string.
If \code{length(ex) > 1}, then a matrix or list of quote values,
1 column/index per input string.
}
\description{
This can be useful for creating custom (shorter) labels for each subset
relative to using the entire subsetting expression.
}
\examples{
ex = '(Substrate=="12C-Con" & Day=="14")'
expr_param_extract(ex)

ex = '(Substrate=="12C-Con" & Day=="14") | (Substrate=="13C-Cel" & Day == "14")'
expr_param_extract(ex)

# returns a matrix
ex = c('(Substrate=="12C-Con" & Day=="14")',
       '(Substrate=="13C-Cel" & Day == "14")')
expr_param_extract(ex)

# returns a list
ex = c('(Substrate=="12C-Con" & Day=="14")',
       '(Substrate=="13C-Cel" & Day == "14")',
       '(Substrate=="13C-Cel")')
expr_param_extract(ex)

}

