/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.util;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.serialize.Serializer;
import org.apache.xalan.serialize.SerializerFactory;
import org.apache.xalan.templates.OutputProperties;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XSLTUtilities {
    private XSLTUtilities() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.err.println("Usage: java -classpath $PTII ptolemy.util.XSLTUtilities inputFile xslFile1 [xslFile2 . . .] outputFile");
            System.exit(2);
        }
        FileWriter fileWriter = new FileWriter(args[args.length - 1]);
        Document inputDocument = XSLTUtilities.parse(args[0]);
        LinkedList<String> transforms = new LinkedList<String>();
        int i = 1;
        while (i < args.length - 1) {
            transforms.add(args[i]);
            ++i;
        }
        Document outputDocument = XSLTUtilities.transform(inputDocument, transforms);
        fileWriter.write(XSLTUtilities.toString(outputDocument));
        fileWriter.close();
    }

    public static Document parse(String filename) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new InputSource(filename));
    }

    public static String toString(Document document) throws Exception {
        Properties format = OutputProperties.getDefaultMethodProperties((String)"xml");
        format.setProperty("indent", "yes");
        format.setProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        Serializer serializer = SerializerFactory.getSerializer((Properties)format);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        serializer.setOutputStream((OutputStream)outputStream);
        serializer.asDOMSerializer().serialize((Node)document);
        ((OutputStream)outputStream).close();
        return ((Object)outputStream).toString();
    }

    public static Document transform(Document inputDocument, String xslFileName) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = transformerFactory.newTransformer(new StreamSource(xslFileName));
        }
        catch (TransformerConfigurationException ex) {
            try {
                Class<?> refClass = Class.forName("ptolemy.util.XSLTUtilities");
                URL entryURL = refClass.getClassLoader().getResource(xslFileName);
                if (entryURL == null) {
                    throw ex;
                }
                transformer = transformerFactory.newTransformer(new StreamSource(entryURL.toString()));
            }
            catch (Exception ex2) {
                throw ex;
            }
        }
        DOMResult result = new DOMResult();
        transformer.transform(new DOMSource(inputDocument), result);
        return (Document)result.getNode();
    }

    public static Document transform(Document inputDocument, List xslFileNames) throws Exception {
        Iterator fileNames = xslFileNames.iterator();
        while (fileNames.hasNext()) {
            String fileName = (String)fileNames.next();
            inputDocument = XSLTUtilities.transform(inputDocument, fileName);
        }
        return inputDocument;
    }

    public static void transform(String xsltFileName, String sourceFileName, String resultFileName) throws Exception {
        FileOutputStream resultStream = new FileOutputStream(resultFileName);
        StreamSource source = new StreamSource(sourceFileName);
        StreamResult result = new StreamResult(resultStream);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(new StreamSource(xsltFileName));
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
        resultStream.flush();
        ((OutputStream)resultStream).close();
    }
}

