###################################################
### chunk number 1: setup
###################################################
#line 183 "Ch_analysing_longitudinal_dataII.Rnw"
rm(list = ls())
if (!file.exists("tables")) dir.create("tables")
if (!file.exists("figures")) dir.create("figures")
set.seed(290875)
options(prompt = "R> ", continue = "+  ",
    width = 63, # digits = 4,
    show.signif.stars = FALSE,
    SweaveHooks = list(leftpar = function()
        par(mai = par("mai") * c(1, 1.05, 1, 1)),
        bigleftpar = function()
        par(mai = par("mai") * c(1, 1.7, 1, 1))))
HSAURpkg <- require("HSAUR2")
if (!HSAURpkg) stop("cannot load package ", sQuote("HSAUR2"))
rm(HSAURpkg)
 ### </FIXME> hm, R-2.4.0 --vanilla seems to need this
a <- Sys.setlocale("LC_ALL", "C")
 ### </FIXME>
book <- TRUE
refs <- cbind(c("AItR", "DAGD", "SI", "CI", "ANOVA", "MLR", "GLM",
                "DE", "RP", "GAM", "SA", "ALDI", "ALDII", "SIMC", "MA", "PCA",
                "MDS", "CA"), 1:18)
ch <- function(x) {
    ch <- refs[which(refs[,1] == x),]
    if (book) {
        return(paste("Chapter~\\\\ref{", ch[1], "}", sep = ""))
    } else {
        return(paste("Chapter~", ch[2], sep = ""))
    }
}
if (file.exists("deparse.R"))
    source("deparse.R")
setHook(packageEvent("lattice", "attach"), function(...) {
    lattice.options(default.theme =
        function()
            standard.theme("pdf", color = FALSE))
    })


###################################################
### chunk number 2: singlebook
###################################################
#line 222 "Ch_analysing_longitudinal_dataII.Rnw"
book <- FALSE


###################################################
### chunk number 3: setup
###################################################
#line 225 "Ch_analysing_longitudinal_dataII.Rnw"
options(digits = 3)
if (!interactive()) {
print.summary.gee <- function (x, digits = NULL, quote = FALSE, prefix = "", ...)
{
    if (is.null(digits))
        digits <- options()$digits
    else options(digits = digits)
    cat("...")
    cat("\nModel:\n")
    cat(" Link:                     ", x$model$link, "\n")
    cat(" Variance to Mean Relation:", x$model$varfun, "\n")
    if (!is.null(x$model$M))
        cat(" Correlation Structure:    ", x$model$corstr, ", M =",
            x$model$M, "\n")
    else cat(" Correlation Structure:    ", x$model$corstr, "\n")
    cat("\n...")
    nas <- x$nas
    if (!is.null(nas) && any(nas))
        cat("\n\nCoefficients: (", sum(nas), " not defined because of singularities)\n",
            sep = "")
    else cat("\n\nCoefficients:\n")
    print(x$coefficients, digits = digits)
    cat("\nEstimated Scale Parameter: ", format(round(x$scale,
        digits)))
    cat("\n...\n")
    invisible(x)
}
}


###################################################
### chunk number 4: ALDII-gee
###################################################
#line 265 "Ch_analysing_longitudinal_dataII.Rnw"
library("gee")


###################################################
### chunk number 5: ALDII-BtheB-data
###################################################
#line 279 "Ch_analysing_longitudinal_dataII.Rnw"
data("BtheB", package = "HSAUR2")
BtheB$subject <- factor(rownames(BtheB))
nobs <- nrow(BtheB)
BtheB_long <- reshape(BtheB, idvar = "subject",
    varying = c("bdi.2m", "bdi.3m", "bdi.5m", "bdi.8m"),
    direction = "long")
BtheB_long$time <- rep(c(2, 3, 5, 8), rep(nobs, 4))
names(BtheB_long)[names(BtheB_long) == "treatment"] <- "trt"


###################################################
### chunk number 6: ALDII-BtheB-geefit-indep
###################################################
#line 289 "Ch_analysing_longitudinal_dataII.Rnw"
osub <- order(as.integer(BtheB_long$subject))
BtheB_long <- BtheB_long[osub,]
btb_gee <- gee(bdi ~ bdi.pre + trt + length + drug,
    data = BtheB_long, id = subject, family = gaussian,
    corstr = "independence")


###################################################
### chunk number 7: ALDII-BtheB-geefit-ex
###################################################
#line 297 "Ch_analysing_longitudinal_dataII.Rnw"
btb_gee1 <- gee(bdi ~ bdi.pre + trt + length + drug,
    data = BtheB_long, id = subject, family = gaussian,
    corstr = "exchangeable")


###################################################
### chunk number 8: ALDII-BtheB-geesummary
###################################################
#line 309 "Ch_analysing_longitudinal_dataII.Rnw"
summary(btb_gee)


###################################################
### chunk number 9: ALDII-BtheB-gee1summary
###################################################
#line 317 "Ch_analysing_longitudinal_dataII.Rnw"
summary(btb_gee1)


###################################################
### chunk number 10: ALDII-respiratory-data
###################################################
#line 326 "Ch_analysing_longitudinal_dataII.Rnw"
data("respiratory", package = "HSAUR2")
resp <- subset(respiratory, month > "0")
resp$baseline <- rep(subset(respiratory, month == "0")$status,
                     rep(4, 111))
resp$nstat <- as.numeric(resp$status == "good")
resp$month <- resp$month[, drop = TRUE]


###################################################
### chunk number 11: ALDII-respiratory-names
###################################################
#line 334 "Ch_analysing_longitudinal_dataII.Rnw"
names(resp)[names(resp) == "treatment"] <- "trt"
levels(resp$trt)[2] <- "trt"


###################################################
### chunk number 12: ALDII-respiratory-fit
###################################################
#line 342 "Ch_analysing_longitudinal_dataII.Rnw"
resp_glm <- glm(status ~ centre + trt + gender + baseline
    + age, data = resp, family = "binomial")
resp_gee1 <- gee(nstat ~ centre + trt + gender + baseline
    + age, data = resp, family = "binomial", id = subject,
    corstr = "independence", scale.fix = TRUE,
    scale.value = 1)
resp_gee2 <- gee(nstat ~ centre + trt + gender + baseline
    + age, data = resp, family = "binomial", id = subject,
    corstr = "exchangeable", scale.fix = TRUE,
    scale.value = 1)


###################################################
### chunk number 13: ALDII-resp-glm-summary
###################################################
#line 358 "Ch_analysing_longitudinal_dataII.Rnw"
summary(resp_glm)


###################################################
### chunk number 14: ALDII-resp-gee1summary
###################################################
#line 366 "Ch_analysing_longitudinal_dataII.Rnw"
summary(resp_gee1)


###################################################
### chunk number 15: ALDII-resp-gee2-summary
###################################################
#line 374 "Ch_analysing_longitudinal_dataII.Rnw"
summary(resp_gee2)


###################################################
### chunk number 16: ALDII-resp-confint
###################################################
#line 382 "Ch_analysing_longitudinal_dataII.Rnw"
se <- summary(resp_gee2)$coefficients["trttrt",
                                      "Robust S.E."]
coef(resp_gee2)["trttrt"] +
    c(-1, 1) * se * qnorm(0.975)


###################################################
### chunk number 17: ALDII-resp-confint-exp
###################################################
#line 393 "Ch_analysing_longitudinal_dataII.Rnw"
exp(coef(resp_gee2)["trttrt"] +
    c(-1, 1) * se * qnorm(0.975))


###################################################
### chunk number 18: ALDII-epilepsy
###################################################
#line 404 "Ch_analysing_longitudinal_dataII.Rnw"
data("epilepsy", package = "HSAUR2")
itp <- interaction(epilepsy$treatment, epilepsy$period)
tapply(epilepsy$seizure.rate, itp, mean)
tapply(epilepsy$seizure.rate, itp, var)


###################################################
### chunk number 19: ALDII-plot1
###################################################
#line 415 "Ch_analysing_longitudinal_dataII.Rnw"
layout(matrix(1:2, nrow = 1))
ylim <- range(epilepsy$seizure.rate)
placebo <- subset(epilepsy, treatment == "placebo")
progabide <- subset(epilepsy, treatment == "Progabide")
boxplot(seizure.rate ~ period, data = placebo,
        ylab = "Number of seizures",
        xlab = "Period", ylim = ylim, main = "Placebo")
boxplot(seizure.rate ~ period, data = progabide,
        main = "Progabide", ylab = "Number of seizures",
        xlab = "Period", ylim = ylim)


###################################################
### chunk number 20: ALDII-plot2
###################################################
#line 434 "Ch_analysing_longitudinal_dataII.Rnw"
layout(matrix(1:2, nrow = 1))
ylim <- range(log(epilepsy$seizure.rate + 1))
boxplot(log(seizure.rate + 1) ~ period, data = placebo,
        main = "Placebo", ylab = "Log number of seizures",
        xlab = "Period", ylim = ylim)
boxplot(log(seizure.rate + 1) ~ period, data = progabide,
        main = "Progabide", ylab = "Log number of seizures",
        xlab = "Period", ylim = ylim)


###################################################
### chunk number 21: ALDII-epilepsy-gee
###################################################
#line 454 "Ch_analysing_longitudinal_dataII.Rnw"
per <- rep(log(2),nrow(epilepsy))
epilepsy$period <- as.numeric(epilepsy$period)
names(epilepsy)[names(epilepsy) == "treatment"] <- "trt"
fm <- seizure.rate ~ base + age + trt + offset(per)
epilepsy_glm <- glm(fm, data = epilepsy, family = "poisson")
epilepsy_gee1 <- gee(fm, data = epilepsy, family = "poisson",
    id = subject, corstr = "independence", scale.fix = TRUE,
    scale.value = 1)
epilepsy_gee2 <- gee(fm, data = epilepsy, family = "poisson",
    id = subject, corstr = "exchangeable", scale.fix = TRUE,
    scale.value = 1)
epilepsy_gee3 <- gee(fm, data = epilepsy, family = "poisson",
    id = subject, corstr = "exchangeable", scale.fix = FALSE,
    scale.value = 1)


###################################################
### chunk number 22: ALDII-espilepsy-glm-summary
###################################################
#line 478 "Ch_analysing_longitudinal_dataII.Rnw"
summary(epilepsy_glm)


###################################################
### chunk number 23: ALDII-espilepsy-gee1-summary
###################################################
#line 486 "Ch_analysing_longitudinal_dataII.Rnw"
summary(epilepsy_gee1)


###################################################
### chunk number 24: ALDII-espilepsy-gee2-summary
###################################################
#line 494 "Ch_analysing_longitudinal_dataII.Rnw"
summary(epilepsy_gee2)


###################################################
### chunk number 25: ALDII-espilepsy-gee3-summary
###################################################
#line 502 "Ch_analysing_longitudinal_dataII.Rnw"
summary(epilepsy_gee3)


###################################################
### chunk number 26: ALDII-respiratory-lmer
###################################################
#line 520 "Ch_analysing_longitudinal_dataII.Rnw"
library("lme4")
resp_lmer <- lmer(status ~ baseline + month +
    trt + gender + age + centre + (1 | subject),
    family = binomial(), data = resp)
exp(fixef(resp_lmer))


###################################################
### chunk number 27: ALDII-resp-lmer-dirty
###################################################
#line 546 "Ch_analysing_longitudinal_dataII.Rnw"
su <- summary(resp_lmer)
if (!interactive()) {
    summary <- function(x) {
        cat("\n...\n")
        cat("Fixed effects:\n")
        printCoefmat(su@coefs)
        cat("\n...\n")
    }
}


###################################################
### chunk number 28: ALDII-resp-lmer-summary
###################################################
#line 561 "Ch_analysing_longitudinal_dataII.Rnw"
summary(resp_lmer)


