% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmstat.dec.R
\name{mmstat.dec}
\alias{mmstat.dec}
\title{mmstat.dec}
\usage{
mmstat.dec(x, ord = NULL)
}
\arguments{
\item{x}{numeric: data vector}

\item{ord}{index: subset of the ordered data (default: \code{NULL})}
}
\value{
The number of significant digits and (the subset of) the order of the data.
}
\description{
Computes the number of the significant digits based on the smallest non-zero difference of the sorted data.
}
\examples{
x <- rnorm(20)
d <- mmstat.dec(x)
# create strings so that they are unique (if they were)
sprintf("\%.*f", d$dec, x)
}
