% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HEMDAG.1.0.0.R
\name{weighted.adjacency.matrix}
\alias{weighted.adjacency.matrix}
\title{Weighted Adjacency Matrix}
\usage{
weighted.adjacency.matrix(file = "edges.txt", compressed = TRUE,
  nodename = TRUE)
}
\arguments{
\item{file}{name of the plain text file to be read (\code{def. edges}). The format of the file is a sequence of rows. 
Each row corresponds to an edge represented through a pair of vertices separated by blanks and the weight of the edge.\cr
For instance: nodeX nodeY score}

\item{compressed}{boolean value:
\itemize{
\item TRUE (def.): the input file must be in a .gz compressed format;
\item FALSE: the input file must be in a plain text format;
}}

\item{nodename}{boolean value:
\itemize{
    \item TRUE (def.): the names of nodes are gene symbol (i.e. characters);
    \item FALSE: the names of the nodes are entrez gene ID (i.e. integer numbers);
}}
}
\value{
a named symmetric weighted adjacency matrix of the graph
}
\description{
Construct a Weighted Adjacency Matrix (wadj matrix) of a graph
}
\details{
The input paramenter nodename sorts the row names of the wadj matrix in increasing order if they are integer number or 
in alphabetic order if they are characters.
}
\examples{
edges <- system.file("extdata/edges.txt", package="HEMDAG");
W <- weighted.adjacency.matrix(file=edges, compressed=FALSE, nodename=TRUE);
}
