% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_heat_map_tp.R
\name{plot_heat_map_tp}
\alias{plot_heat_map_tp}
\title{Plots heat maps for significant peptides.}
\usage{
plot_heat_map_tp(
  df,
  mar_x = 3.5,
  ranges = c(-Inf, seq(-30, 30, by = 10), Inf),
  pv_cutoff = 0.01,
  replicates = 3
)
}
\arguments{
\item{df}{average data frame. Generated using ave_timepoint() function.}

\item{mar_x}{margin x width. Default=3.5}

\item{ranges}{ranges for coloring scheme. Default set to c(-Inf, seq(-30, 30, by=10), Inf)}

\item{pv_cutoff}{p-value cutoff here set up to 0.01}

\item{replicates}{number of replicates in sample. Default set to 3.}
}
\value{
heat map for average uptake per residue for significant peptides.
}
\description{
Returns heat map with average values for significant uptake per residue.
}
\examples{
file_nm<-system.file("extdata", "All_results_table.csv", package = "HDXBoxeR")
a<- output_tp(file_nm)
plot_heat_map_tp(df=a, replicates=3, pv_cutoff=0.01,
ranges=c(-Inf,-40, -30,-20,-10, 0,10, 20,30,40, Inf) )
plot_heat_map_tp(df=a)
}
