% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mean_shrink.R
\name{mean_bop19}
\alias{mean_bop19}
\title{BOP shrinkage estimator}
\usage{
mean_bop19(x, mu_0 = rep(1, p))
}
\arguments{
\item{x}{a p by n matrix or a data frame. Rows represent different variables, columns- observations.}

\item{mu_0}{a numeric vector. The target vector used in the construction of the shrinkage estimator.}
}
\value{
a numeric vector containing the shrinkage estimation of the mean vector
}
\description{
Shrinkage estimator of the high-dimensional mean vector as suggested in \insertCite{BOP2019;textual}{HDShOP}.
It uses the formula
\deqn{\hat \mu_{BOP} = \hat \alpha \bar x + \hat \beta \mu_0 \quad ,} where
\eqn{\hat \alpha} and \eqn{\hat \beta} are shrinkage coefficients given by Eq.(6) and Eg.(7)
of \insertCite{BOP2019;textual}{HDShOP} that minimize weighted quadratic loss for a given
target vector \eqn{\mu_0} (shrinkage target). \eqn{\bar x} stands for the
sample mean vector.
}
\examples{
n<-7e2 # number of realizations
p<-.5*n # number of assets
x <- matrix(data = rnorm(n*p), nrow = p, ncol = n)
mm <- mean_bop19(x=x)
}
\references{
\insertAllCited{}
}
