% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.H2x2Factorial.R
\name{graph.H2x2Factorial}
\alias{graph.H2x2Factorial}
\title{H2x2Factorial Plot}
\usage{
graph.H2x2Factorial(m_lower=10, m_upper=100, m_step=2,
                    CV=c(0,0.3,0.6,0.9),
                    palette=c("#0F2080","#85C0F9","#DDCC77","#F5793A","#A95AA1"),
                    line_width=rep(3,5), line_type=seq(1,5,1), title=NULL,
                    power=0.8, alpha=0.05,
                    pi_x=0.5, pi_z=0.5,
                    delta_x=0.25, delta_z=0.33, delta_xz=0.3, sigma2_y=1, rho=0,
                    test="cluster", correction=FALSE,
                    max_n=1e8, seed_mix=NULL, size_mix=1e4,
                    verbose=TRUE)
}
\arguments{
\item{m_lower}{a numeric value larger than 2 for the lower bound of the mean cluster sizes on the horizontal axis. Default is \code{10}.}

\item{m_upper}{a numeric value larger than \code{m_lower} for the upper bound of the mean cluster sizes on the horizontal axis. Default is \code{100}.}

\item{m_step}{a positive numeric value for the step size on the horizontal axis for plotting the sample size combinations. Default is \code{2}.}

\item{CV}{a vector of positive numeric values for a series of coefficients of variation of the cluster sizes. The length of CV vector equals the number
of lines presented in the plot, so the CV vector with a length less or equal to 5 is suggested for making a clear-looking graph. Besides, a reasonable magnitude of CV is highly recommended to produce effective plots.
Default is \code{c(0, 0.3, 0.6, 0.9)}.}

\item{palette}{a vector of character values to specify the color choices corresponding to the lines in the plot.
Default is \code{c("#0F2080", "#85C0F9", "#DDCC77", "#F5793A", "#A95AA1")}. The order should be matched with the specification of CV and the number of elements should be no less than that for CV vector.}

\item{line_width}{a vector of numeric values to specify the widths of the lines in the plot. Default is \code{rep(3, 5)}. The order should be matched with the specification of CV and the number of elements should be no less than that for CV vector.}

\item{line_type}{a vector of numeric values to specify the line types of the lines in the plot. Default is \code{seq(1, 5, 1)}. The order should be matched with the specification of CV and the number of elements should be no less than that for CV vector.}

\item{title}{a user-defined title or caption for the plot. Default is \code{NULL}. By default, a formal test name will be automatically given.}

\item{power}{a numeric value between 0 and 1 as the desired power level for sample size estimation. Default is \code{0.8}.}

\item{alpha}{a numeric value between 0 and 1 as the type I error rate. Default is \code{0.05}.}

\item{pi_x}{a numeric value between 0 and 1 as the proportion of clusters randomized to the cluster-level treatment. Default is \code{0.5}, representing a balanced allocation.}

\item{pi_z}{a numeric value between 0 and 1 as the proportion of individuals randomized to the individual-level treatment within each cluster. Default is \code{0.5}, representing a balanced allocation.}

\item{delta_x}{a nonzero numeric value for the (unstandardized) effect size of the marginal cluster-level treatment effect. Default is \code{0.25}, which is the hypothetical value for the example in the referenced paper.}

\item{delta_z}{a nonzero numeric value for the (unstandardized) effect size of the marginal individual-level treatment effect. Default is \code{0.33}, which is the hypothetical value for the example in the referenced paper.}

\item{delta_xz}{a nonzero numeric value for the (unstandardized) effect size of the interaction effect of the two treatments. Default is \code{0.3}, which is the hypothetical value for the example in the referenced paper.}

\item{sigma2_y}{a positive numeric value for the total variance of the continuous outcome. Default is \code{1}.}

\item{rho}{a numeric value between 0 and 1 as the intraclass correlation coefficient characterizing the between-cluster variability. Default is \code{0}.}

\item{test}{a character argument indicating the type of hypothesis test of interest. Supported values include
\code{"cluster"} (test for marginal cluster-level treatment effect), \code{"individual"} (test for marginal individual-level treatment effect),
\code{"interaction"} (interaction test for the two treatments), \code{"joint"} (joint test for the two marginal treatment effects),
\code{"I-U"} (intersection-union test for the two marginal effects). Default is \code{"cluster"}.}

\item{correction}{a logical argument indicating whether a finite sample correction should be used. Default is \code{FALSE}.}

\item{max_n}{an optional setting of a maximum number of clusters, which is only functional under \code{test="cluster"}, \code{"joint"}, or \code{"I-U"}. Default is \code{1e8}.}

\item{seed_mix}{an optional setting of a seed for conducting the simulation-based testing under a mixed distribution, which is only functional under \code{test="joint"}. Default is \code{NULL}.}

\item{size_mix}{a pre-specified size for the mixed distribution in the simulation-based procedure, which is only needed under \code{test="joint"}. Default is \code{1e4}.}

\item{verbose}{a logical argument indicating whether the parameter reiterations and supplementary messages should be presented or suppressed. Default is \code{TRUE}.}
}
\value{
\code{graph.H2x2Factorial} returns a plot comparing the sample size requirements under different CV, with some suppressible messages.
}
\description{
The function \code{graph.H2x2Factorial} plots the sample size estimations or combinations of mean cluster sizes and cluster numbers
under variable CV for a chosen test. Based on the desired test and power, the function produces a plot with mean cluster size on the x-axis and number of clusters on
the y-axis, with multiple lines representing the dynamic sample size constraints if a vector of CV is specified. The limits of the y-axis
will be automatically adjusted based on the extreme values calculated. A color-blind-friendly palette is set by default but it can be updated by users.
}
\examples{
#Make a plot under the test for marginal cluster-level treatment effect
graph.H2x2Factorial(power=0.9, test="cluster", rho=0.1, verbose=FALSE)

}
