% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rhead.R
\name{rhead}
\alias{rhead}
\title{Random Head}
\usage{
rhead(data, rows = 7, is.random = TRUE)
}
\arguments{
\item{data}{A vector or data.frame from which a small sample is to be returned}

\item{rows}{A positive integer, representing the number of lines or elements to print, default is 7.}

\item{is.random}{a boolean. If TRUE, a random sample is drawn, else it takes the head() of the data}
}
\value{
A random sample without replacement taken from the data, in the same format than the input.
}
\description{
Small Random Sample from a vector or data.frame
}
\details{
If the rows parameter is greater than the actual number of rows/elements of the data, the returned value is the initial dataset after shuffling
}
\examples{
set.seed(1234)
rhead(mtcars)
}
