% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_growth_model.R
\name{summarize_growth_model}
\alias{summarize_growth_model}
\title{Summarize growth model object and data}
\usage{
summarize_growth_model(
  data_frame,
  growth_model_object,
  model_type = "mixed",
  function_type = "exponential",
  fixed_rate = TRUE,
  time_unit = "hours"
)
}
\arguments{
\item{data_frame}{A data frame object that at minimum contains three
variables:
\itemize{
\item cluster - a character type variable used to specify how observations
are nested or grouped by a particular cluster. Note if using a
least-squares model, please fill in cluster values with a single repetitive
dummy variable (e.g., '1'), do not leave blank.
\item time - a numeric type variable used for measuring time such as
minutes, hours, or days
\item growth_metric - a numeric type variable used for measuring growth
over time such as cell count or confluency
}}

\item{growth_model_object}{The model object that is created using
the \code{\link{growth_curve_model_fit}}}

\item{model_type}{A character string specifying the model_type that was
fit using the \code{\link{growth_curve_model_fit}} function. Options
include either "mixed" or "least-squares". Defaults to "mixed".}

\item{function_type}{A character string specifying the function for
modeling the shape of the growth. Options include "exponential", "linear",
"logistic", or "gompertz".}

\item{fixed_rate}{A logical value specifying whether the rate constant
of the function should be treated as a fixed effect (TRUE) or random
effect (FALSE). Defaults to TRUE}

\item{time_unit}{A character string specifying the units in which time is
measured in. Defaults to "hours"}
}
\value{
A list object with the following data frames within the list:
\itemize{
\item model_summary_wide - a data frame with 1 row containing
key model estimates, doubling-time, and model metrics depending
on the model_type and function_type specified
\item model_summary_long - a data frame that is a long dataset version of
'model_summary_wide' that can be used to generate a table of the model
results (see function \code{\link{growth_model_summary_table}})
\item model_residual_data - a data frame containing the original data
frame values as well as predicted values, residuals, and theoretical
quantiles of the residuals depending on the model_type selected
(see functions \code{\link{growth_model_residual_plots}} and
\code{\link{growth_vs_time_plot}})
\item model_sim_pred_data - a data frame with estimates and 95\% prediction
intervals (not to be confused with the 95\% confidence intervals calculated
from the model estimates), for mixed-effects models, values are calculated
as the median estimate and the 2.5th and 97.5th percentiles of the
simulated data from the saemix model at each time point (see
\code{\link[saemix]{compute.sres}} and \code{\link[saemix]{plot}} with
plot.type = "vpc"). For least-squares models, prediction intervals are
calculated through Taylor-series approximations using the
\code{\link[investr]{predFit}} function.
}
}
\description{
This function is used to create a list object of
data frames based on a user's input data and output
growth model object from \code{\link{growth_curve_model_fit}}.
The list object (referred to in this package as 'growth_model_summary_list')
can be used to extract model predicted values, residuals, and can be
inputted into supporting functions from GrowthCurveME to
generate plots and perform model diagnostics.
}
\examples{
# Load example data (exponential data)
data(exp_mixed_data)
# Fit an mixed-effects growth model to the data
exp_mixed_model <- growth_curve_model_fit(
data_frame = exp_mixed_data,
function_type = "exponential",
return_summary = FALSE)
# Summarize the data by creating a summary list object
exp_mixed_model_summary <- summarize_growth_model(
data_frame = exp_mixed_data,
growth_model_object = exp_mixed_model,
model_type = "mixed",
function_type = "exponential",
time_unit = "hours")
# Extracting a data frame from the list object
model_summary_wide <- exp_mixed_model_summary[["model_summary_wide"]]
}
\seealso{
\code{\link{growth_curve_model_fit}}
}
