% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestplotRegrObj.R
\name{forestplotRegrObj}
\alias{forestplotRegrObj}
\alias{forestplotRegrObj.default}
\alias{forestplotRegrObj.coxph}
\alias{forestplotRegrObj.lrm}
\alias{forestplotRegrObj.lm}
\alias{forestplotRegrObj.glm}
\alias{forestplotRegrObj.list}
\alias{fpBoxSize}
\title{Forest plot for multiple models}
\usage{
forestplotRegrObj(
  regr.obj,
  postprocess_estimates.fn = function(x) x,
  rowname = "Variable",
  ci.txt = "CI",
  ci.glue = "{lower} to {higher}",
  digits = 1,
  get_box_size = fpBoxSize,
  ...
)

\method{forestplotRegrObj}{default}(
  regr.obj,
  postprocess_estimates.fn = function(x) x,
  rowname = "Variable",
  ci.txt = "CI",
  ci.glue = "{lower} to {higher}",
  digits = 1,
  get_box_size = fpBoxSize,
  ...
)

\method{forestplotRegrObj}{coxph}(
  regr.obj,
  postprocess_estimates.fn = function(x) x,
  rowname = "Variable",
  ci.txt = "CI",
  ci.glue = "{lower} to {higher}",
  digits = 1,
  get_box_size = fpBoxSize,
  xlab = "Hazard Ratio",
  estimate.txt = "HR",
  xlog = TRUE,
  zero = 1,
  exp = TRUE,
  ...
)

\method{forestplotRegrObj}{lrm}(
  regr.obj,
  postprocess_estimates.fn = function(x) x,
  rowname = "Variable",
  ci.txt = "CI",
  ci.glue = "{lower} to {higher}",
  digits = 1,
  get_box_size = fpBoxSize,
  xlab = "Odds ratio",
  estimate.txt = "HR",
  xlog = TRUE,
  zero = 1,
  exp = TRUE,
  ...
)

\method{forestplotRegrObj}{lm}(
  regr.obj,
  postprocess_estimates.fn = function(x) x,
  rowname = "Variable",
  ci.txt = "CI",
  ci.glue = "{lower} to {higher}",
  digits = 1,
  get_box_size = fpBoxSize,
  xlab = "Effect",
  estimate.txt = "Coef",
  xlog = FALSE,
  zero = 0,
  exp = FALSE,
  ...
)

\method{forestplotRegrObj}{glm}(
  regr.obj,
  postprocess_estimates.fn = function(x) x,
  rowname = "Variable",
  ci.txt = "CI",
  ci.glue = "{lower} to {higher}",
  digits = 1,
  get_box_size = fpBoxSize,
  xlab = NULL,
  xlog = NULL,
  zero = NULL,
  estimate.txt = NULL,
  exp = NULL,
  ...
)

\method{forestplotRegrObj}{list}(
  regr.obj,
  postprocess_estimates.fn = function(x) x,
  rowname = "Variable",
  ci.txt = "CI",
  ci.glue = "{lower} to {higher}",
  digits = 1,
  get_box_size = fpBoxSize,
  xlab = NULL,
  xlog = NULL,
  zero = NULL,
  estimate.txt = NULL,
  exp = NULL,
  ...
)

fpBoxSize(p_values, variable_count, boxsize, significant = 0.05)
}
\arguments{
\item{regr.obj}{A regression model object. It should be of coxph, crr or glm class.
Warning: The glm is not fully tested.}

\item{postprocess_estimates.fn}{A function that takes the regression outputs and returns
the same data with modifications. The input columns are:

* `Rowname`
* `Coef`
* `Lower`
* `Upper`
* `Sort`}

\item{rowname}{The name of the variables}

\item{ci.txt}{The text above the confidence interval, defaults to `"CI"`}

\item{ci.glue}{The string used for [glue::glue()] the `lower` and `higher`
confidence intervals together.}

\item{digits}{The number of digits to round presented values to}

\item{get_box_size}{A function for extracting the box sizes}

\item{...}{Passed to \code{\link[forestplot]{forestplot}()}}

\item{xlab}{x-axis label}

\item{estimate.txt}{The text above the estimate, e.g. Est, HR}

\item{xlog}{If TRUE, x-axis tick marks are to follow a logarithmic scale, e.g. for
logistic regression (OR), survival estimates (HR), Poisson regression etc.
\emph{Note:} This is an intentional break with the original \code{forestplot}
function as I've found that exponentiated ticks/clips/zero effect are more
difficult to for non-statisticians and there are sometimes issues with rounding
the tick marks properly.}

\item{zero}{Indicates what is zero effect. For survival/logistic fits the zero is
1 while in most other cases it's 0.}

\item{exp}{Report in exponential form. Default true since the function was built for
use with survival models.}

\item{p_values}{The p-values that will work as the foundation for the box size}

\item{variable_count}{The number of variables}

\item{boxsize}{The default box size}

\item{significant}{Level of significance .05}
}
\description{
Plot different model fits with similar variables in order to
compare the model's estimates and confidence intervals. Each
model is represented by a separate line on top of eachother
and are therefore ideal for comparing different models. This
extra appealing when you have lots of variables included in
the models.
}
\examples{
org.par <- par("ask" = TRUE)

library(tidyverse)
# simulated data to test
set.seed(102)
cov <- tibble(ftime = rexp(200)) |> 
  mutate(x1 = runif(n()),
         x2 = runif(n()),
         x3 = runif(n()),
         fstatus1 = if_else(x1 * 1 + 
                              x2 * 0.2 + 
                              x3 * 0.5 + 
                              runif(n()) * 0.5 > 1, 
                            1, 0),
         fstatus2 = if_else(x1 * 0.2 + 
                              x2 * 0.5 + 
                              x3 * 0.1 + 
                              runif(n()) * 2 > 1, 
                            1, 0)) |> 
  # Add some column labels
  Gmisc::set_column_labels(x1 = "First variable",
                           x2 = "Second variable")

library(rms)
dd <- datadist(cov)
options(datadist = "dd")

fit1 <- cph(Surv(ftime, fstatus1 == 1) ~ x1 + x2 + x3, data = cov)
fit1 |> 
  forestplotRegrObj()

fit2 <- update(fit1, Surv(ftime, fstatus2 == 1) ~ .)
list("Frist model" = fit1, "Second model"  = fit2) |> 
  forestplotRegrObj(legend_args = fpLegend(title = "Type of regression"),
                    postprocess_estimates.fn = \(x) filter(x, str_detect(column_term, "(x2|x3)")),
                    col = fpColors(box = c("darkblue", "darkred")))


par(org.par)
}
\seealso{
Other forestplot wrappers: 
\code{\link{forestplotCombineRegrObj}()}
}
\concept{forestplot wrappers}
