% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GoMiner.R
\name{GOtable3}
\alias{GOtable3}
\title{GOtable3}
\usage{
GOtable3(hgncList, DB)
}
\arguments{
\item{hgncList}{character list of gene names}

\item{DB}{selected ontology branch of return value of subsetGOGOA}
}
\value{
returns a list whose components are c("DB","table","ngenes")
where 'DB' is the GO DB subsetted to the desired ONTOLOGY,
and 'table' is tabulation of number of occurrences of each GO
category name within the desired ONTOLOGY,
and ngenes is the total number of hgncList genes mapping to GOGOA
}
\description{
tabulate number of geneList mappings to GO categories
}
\examples{
\dontrun{
# GOGOA3.RData is too large to include in the R package
# so I need to load it from a file that is not in the package.
# Since this is in a file in my own file system, I could not
# include this as a regular example in the package.
# you can generate it using the package 'minimalistGODB'
# or you can retrieve it from https://github.com/barryzee/GO/tree/main/databases
load("/Users/barryzeeberg/personal/GODB_RDATA/goa_human/GOGOA3_goa_human.RData")
x<-GOtable3(cluster52,GOGOA3$ontologies[["biological_process"]])
}

}
