% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/figCaptionNo.R
\name{figCapNo}
\alias{figCapNo}
\title{Adds a figure caption number}
\usage{
figCapNo(str, roman = getOption("fig_caption_no_roman", FALSE),
  sprintf_str = getOption("fig_caption_no_sprintf", "Fig. \%s: \%s"))
}
\arguments{
  \item{str}{The string that is to be prepended with
  string}

  \item{roman}{Whether or not to use roman numbers instead
  of arabic. Can also be set through
  \code{options(fig_caption_no_roman = TRUE)}}

  \item{sprintf_str}{An \code{\link[base]{sprintf}}
  formatted string where the first argument is reserved for
  the string generated by the counter and the second one is
  for the caption text. Can also be set through
  \code{options(fig_caption_no_sprintf = TRUE)}}
}
\description{
The function relies on \code{options("fig_caption_no")} in
order to keep track of the last number. If you want to
force the caption function to skip captions while still
using it in the knitr fig.cap option then simply set
\code{options(fig_caption_no = FALSE)}
}
\examples{
\dontrun{
```{r, fig.cap=figCapNo("My nice plot")}
plot(1:10 + rnorm(10), 1:10)
```
}
org_opts <- options(fig_caption_no = 2,
                    fig_caption_no_sprintf = "Figure \%s: \%s")
figCapNo("A plot with caption number = 3")

org_opts <- options(fig_caption_no = TRUE)
figCapNo("A plot with caption number =  1")

# Use default setting
options(fig_caption_no_sprintf = NULL)
figCapNo("A plot with caption number =  2")

# Return the original settings
options(org_opts)
}
\seealso{
Other figure caption functions: \code{\link{figCapNoLast}};
\code{\link{figCapNoNext}}
}

