% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi_perm.r
\name{chiperm}
\alias{chiperm}
\title{R function for permutation-based chi-square test of independence}
\usage{
chiperm(
  data,
  B = 999,
  resid = FALSE,
  filter = FALSE,
  thresh = 1.96,
  cramer = FALSE
)
}
\arguments{
\item{data}{Dataframe containing the input contingency table.}

\item{B}{Desired number of permuted tables (999 by default).}

\item{resid}{TRUE or FALSE (default) if the user does or doesn't want to plot the table of
Pearson's standardized residuals.}

\item{filter}{Takes TRUE or FALSE (default) if the user does or does't want to filter the
Pearson's standardized residuals according to the threshold provided by the thresh parameter;
by default, the threshold is set at 1.96, which corresponds to an alpha level of 0.05.}

\item{thresh}{Value of the standardized residuals below which the residuals will be not
displayed (by default, the threshold is set at 1.96, which corresponds to an alpha level of
0.05).}

\item{cramer}{Takes TRUE or FALSE (default) if the user does or doesn't want to calculate and
plot the bootstrap confidence interval for Cramer's V.}
}
\value{
The function produces:\cr
(1) a chart that displays the permuted distribution of the
chi-square statistic based on B permuted tables. The selected number of permuted tables, the
observed chi-square, the 95th percentile of the permuted distribution, and the associated p value
are reported at the bottom of the chart;\cr

(2) a chart that displays the bootstrap distribution of Cramer's V coefficient, based on a number
of bootstrap replicates which is equal to the value of the function's parameter B;\cr

(3) a chart that the Pearson's Standardized Residuals: a colour scale allows to easily understand
which residual is smaller (BLUE) or larger (RED) than expected under the hypothesis of
independence. Should the user want to only display residuals larger than a given threshold, it
suffices to set the filter parameter to TRUE, and to specify the desired threshold by means of
the thresh parameter, which is set at 1.96 by default.
}
\description{
The function performs the chi-square test of independence on the basis of permuted tables, whose
number is selected by user.\cr
}
\details{
For the rationale of this approach, see for instance the description provided by:\cr Beh E.J.,
Lombardo R. 2014, Correspondence Analysis: Theory, Practice and New Strategies, Chichester,
Wiley, pages 62-64.\cr
}
\examples{
data(assemblage)
chiperm(data=assemblage, B=199, resid=TRUE, cramer=TRUE)

}
\keyword{chiperm}
