% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdfpd_GetDFPData.R
\name{gdfpd.GetDFPData}
\alias{gdfpd.GetDFPData}
\title{Downloads and reads financial reports from B3's DFP/FRE/FCA system}
\usage{
gdfpd.GetDFPData(name.companies, first.date = Sys.Date() - 12 * 30,
  last.date = Sys.Date(), selected.data = "DFP|FRE|FCA",
  inflation.index = "dollar", max.levels = 3, folder.out = tempdir(),
  do.cache = TRUE, cache.folder = "DFP Cache Folder",
  fetch.new.files = FALSE, max.dl.tries = 10)
}
\arguments{
\item{name.companies}{Official names of companies to get financial reports (e.g. 'ELETROPAULO METROPOLITANA EL.S.PAULO S.A').
Names of companies can be found using function gdfpd.search.company('nametolookfor') or gdfpd.get.info.companies('companies')}

\item{first.date}{First date (YYYY-MM-DD) to get data. Character or Date. E.g. first.date = '2010-01-01'.}

\item{last.date}{Last date (YYYY-MM-DD) to get data. Character or Date. E.g. last.date = '2017-01-01'.}

\item{selected.data}{Symbols for the selection of datasets: 'DFP|FRE|FCA', 'DFP|FRE', 'FRE|FCA', 'DFP|FCA', 'DFP', 'FRE', 'FCA'. Default = 'DFP|FRE|FCA'}

\item{inflation.index}{Sets the inflation index to use for finding inflation adjusted values of all reports. Possible values: 'dollar' (default) or 'IPCA', the brazilian main inflation index.
When using 'IPCA', the base date is set as the last date found in the DFP dataset.}

\item{max.levels}{Sets the maximum number of levels of accounting items in financial reports (default = 3)}

\item{folder.out}{Folder where to download and manipulate the zip files. Default = tempdir()}

\item{do.cache}{Logical for controlling to whether to use a cache system or not. Default = TRUE}

\item{cache.folder}{Folder to cache (save) all processed information. Default = file.path(getwd(),'DFP Cache Folder')}

\item{fetch.new.files}{Logical. Should the function search for new files/data in Bovespa? (default = FALSE)}

\item{max.dl.tries}{Maximum number of attempts for dowloading files}
}
\value{
A tibble object with all gathered financial statements, with each company as a row
}
\description{
Annual data for financial reports and corporate events are downloaded from B3 for a combination of companies and time period.
This function gathers data into a single tibble object and organizes it in a tabular/long format.
}
\details{
The easiest way to get started with gdfpd.GetDFPData is looking for the official name of traded companies using function gdfpd.search.company('nametolookfor').
Alternatively, you can use function gdfpd.get.info.companies('companies') to import a dataframe with information for all available companies and time periods.
}
\examples{

\dontrun{ #dontrun: keep cran check time short
name.companies <- 'ELETROPAULO METROPOLITANA EL.S.PAULO S.A'
first.date <- '2005-01-01'
last.date <-  '2006-01-01'

df.statements <- gdfpd.GetDFPData(name.companies = name.companies,
                                  first.date = first.date,
                                  last.date = last.date)
 }
}
