% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CNV.R
\name{diff_CNV}
\alias{diff_CNV}
\title{Do difference analysis of gene level copy number variation data}
\usage{
diff_CNV(cnvData, sampleGroup)
}
\arguments{
\item{cnvData}{data.frame of CNV data}

\item{sampleGroup}{vector of sample group}
}
\description{
Do difference analysis of gene level copy number variation data
}
\examples{
\dontrun{
library(TCGAbiolinks)
query <- GDCquery(project = "TCGA-LGG",
                  data.category = "Copy Number Variation",
                  data.type = "Gene Level Copy Number Scores")

GDCdownload(query, method = "api", files.per.chunk = 5, directory = Your_Path)
data <- GDCprepare(query = query, 
                   save = TRUE, 
                   directory =  "Your_Path") 

class(data) <- "data.frame"
cnvData <- data[, -c(1,2,3)]
rownames(cnvData) <- data[, 1]
sampleGroup  = sample(c("A","B"), ncol(cnvData), replace = TRUE)
diffCnv <- diff_CNV(cnvData, sampleGroup)
}
}
