% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_ld.R
\name{calculate_ld}
\alias{calculate_ld}
\title{Calculate linkage disequilibrium statistics
This function calculates two matrices, once containing all pairwise
linkage disequilibrium (ld) values, and one matrix containing all pairwise r
statistics}
\usage{
calculate_ld(
  pop,
  sampled_individuals = 10,
  number_of_markers = 100,
  random_markers = TRUE
)
}
\arguments{
\item{pop}{focal population}

\item{sampled_individuals}{Number of individuals randomly sampled to
calculate the LD matrices}

\item{number_of_markers}{Number of markers used to calculate the ld matrices}

\item{random_markers}{If TRUE, markers are randomly spaced along the
chromosome, if FALSE, markers are equidistantly spaced along the chromosome.}
}
\value{
An object containing two items:
\item{ld_matrix}{
  Pairwise ld statistics for all markers
}
\item{rsq_matrix}{
  Pairwise rsq statistics for all markers
}
}
\description{
Calculate linkage disequilibrium statistics
This function calculates two matrices, once containing all pairwise
linkage disequilibrium (ld) values, and one matrix containing all pairwise r
statistics
}
\examples{
wildpop <- simulate_admixture(pop_size = 100,
                              number_of_founders = 10,
                              total_runtime = 100,
                              morgan = 1)

ld_results <- calculate_ld(pop = wildpop,
                           number_of_markers = 10,
                           random_markers = TRUE)

plot(ld_results$ld_matrix~ld_results$dist_matrix,
     pch = 16,
     xlab="Distance between markers",
     ylab = "Linkage Disequilibrium")
}
