% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pop_genomics.R
\name{Fst}
\alias{Fst}
\title{Fst}
\usage{
Fst(
  vcf_path,
  pop1_individuals,
  pop2_individuals,
  weighted = FALSE,
  batch_size = 10000,
  threads = 1,
  write_log = FALSE,
  logfile = "log.txt",
  window_size = NULL,
  skip_size = NULL
)
}
\arguments{
\item{vcf_path}{Path to the VCF file.}

\item{pop1_individuals}{Vector of individual names belonging to the first population.}

\item{pop2_individuals}{Vector of individual names belonging to the second population.}

\item{weighted}{Logical, whether weighted Fst or mean Fst is returned (Default = FALSE (mean Fst is returned)).}

\item{batch_size}{The number of variants to be processed in each batch
(used in batch mode only, default of 10,000 should be suitable for most use cases).}

\item{threads}{Number of threads to use for parallel processing.}

\item{write_log}{Logical, indicating whether to write progress logs.}

\item{logfile}{Path to the log file where progress will be logged.}

\item{window_size}{Size of the window for windowed analysis in base pairs (optional).
When specified, \code{skip_size} must also be provided.}

\item{skip_size}{Number of base pairs to skip between windows (optional).
Used in conjunction with \code{window_size} for windowed analysis.}
}
\value{
In batch mode (no window_size or skip_size provided): Fst value (either mean or weighted).
In window mode (window_size and skip_size provided): A data frame with columns 'Chromosome', 'Start', 'End', and 'Fst', representing the fixation index within each window.
}
\description{
This function calculates the fixation index (Fst) between two populations from a VCF file using the method of Weir and Cockerham (1984).
The formula used for this is equivalent to the one used in vcftools --weir-fst-pop (https://vcftools.sourceforge.net/man_latest.html).
For batch processing, it uses \code{process_vcf_in_batches}. For windowed analysis, it uses a similar
approach tailored to process specific genomic windows (\code{process_vcf_in_windows}).
}
\examples{
\donttest{vcf_file <- system.file("tests/testthat/sim.vcf.gz", package = "GenoPop")
index_file <- system.file("tests/testthat/sim.vcf.gz.tbi", package = "GenoPop")
pop1_individuals <- c("tsk_0", "tsk_1", "tsk_2")
pop2_individuals <- c("tsk_3", "tsk_4", "tsk_5")
# Batch mode example
fst_value <- Fst(vcf_file, pop1_individuals, pop2_individuals, weighted = TRUE)
# Window mode example
fst_windows <- Fst(vcf_file, pop1_individuals, pop2_individuals, weighted = TRUE,
                   window_size = 100000, skip_size = 50000)}

}
