### fisher.g.test.R (2004-01-15)
###
###     Fisher's exact g test
###
### Copyright 2003-04 Konstantinos Fokianos and Korbinian Strimmer
###
###
### This file is part of the `GeneTS' library for R and related languages.
### It is made available under the terms of the GNU General Public
### License, version 2, or at your option, any later version,
### incorporated herein by reference.
### 
### This program is distributed in the hope that it will be
### useful, but WITHOUT ANY WARRANTY; without even the implied
### warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
### PURPOSE.  See the GNU General Public License for more
### details.
### 
### You should have received a copy of the GNU General Public
### License along with this program; if not, write to the Free
### Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
### MA 02111-1307, USA


# The following function calculates the p-value of
# Fisher's exact g test given a single time series
#
# note that constant times series result in a p-value of 1
# (i.e. the null hypothesis of a purely random process is not rejected)

# Fishers exact g test (single time series, x is a vector)
fisher.g.test.single <- function(x, ...) 
{
    # constant time series result in a p-value of 1
    if( is.constant.single(x) ) return(1)
    
    m <- floor(length(x)/2)
    f.spec <- periodogram.spec(x, ...)
      
    # Max Periodogram at Frequency w1 in radians/unit time:
    w1 <- (1:length(f.spec))[f.spec == max(f.spec)][1] # [1] because we may have multiple maxima...    
    fisher   <- f.spec[w1]/sum(f.spec)
    upper    <- floor(1/fisher)
    compose  <- rep(NA, length=upper)
    for (j in 1:upper)
    {
      compose[j]  <- (gamma(m+1)/(gamma(j+1)*gamma(m-j+1)))*((-1)^(j-1))*(1-j*fisher)^(m-1)
    }
    pval  <- sum(compose)  
    if (pval > 1) pval <- 1 # this may happen due to numerical error
    
    return(pval)
}

# Fishers exact g test (multiple time series)
fisher.g.test <- function(x, ...) 
{
  if (is.matrix(x))
  {
    num.series <- dim(x)[2] # number of columns
    pvalues <- rep(NA, length=num.series)
    for (i in 1:num.series)
    {
       pvalues[i] <- fisher.g.test.single(x[,i], ...)
    }
    return(pvalues)
  }
  else # single time series
  {
    return(fisher.g.test.single(x, ...))
  }
}
