% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QUANTILE.R
\name{QUANTILE}
\alias{QUANTILE}
\title{Quantile function}
\usage{
QUANTILE(family, p, param, size = 0)
}
\arguments{
\item{family}{distribution name; run the function distributions() for help}

\item{p}{values at which the quantile needs to be computed; between 0 and 1; (e.g 0.01, 0.05)}

\item{param}{parameters of the distribution; (1 x p)}

\item{size}{additional parameter for some discrete distributions; run the command distributions() for help}
}
\value{
\item{q}{quantile/VAR}
}
\description{
This function computes the quantile function of a univariate distribution
}
\examples{
family = "gaussian"

Q = 1 ; theta = matrix(c(-1.5, 1.7),1,2) ;
quantile = QUANTILE(family, (0.01), theta)
print('Quantile : ')
print(quantile)

}
