% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carcass_persistence_functions.R
\name{desc}
\alias{desc}
\title{Descriptive statistics for a fitted CP model}
\usage{
desc(model_CP, Ir = c(1, 3, 7, 14, 28), CL = 0.9, nsim = 10000)
}
\arguments{
\item{model_CP}{A fitted CP model (cpm object)}

\item{Ir}{The intervals for which to calculate the r statistics}

\item{CL}{The confidence level for the CIs.}

\item{nsim}{Number of simulation draws for estimating CIs}
}
\value{
Matrix of point and interval estimates for the median CP and the r
 statistics for the specified intervals. The matrix is assigned to class
 \code{descCP} that is simply a matrix with dimensions
 \code{ncell x 1 + 3*(1 + length(Ir))}, column names that give the number of
 observations in each cell, statistic name and upper and lower bounds
`(in triplets), and row names giving the names of the cells.
}
\description{
Given a cpm object, calculate convenient descriptive statistics,
 including the median and specified rI statistics along with estimated CIs.
}
\details{
The CIs for the r statistics (and the medianCP for the Weibull) ara
 based on simulation of the \code{pda} and \code{pdb} parameters, calculation
 of the statistics, and taking the empirical distribution of the simulated
 values.

 NOTE: rI is the probability that a carcass that arrives at a uniform random
 time in an interval of I days will persist until the first search after
 arrival.
}
\seealso{
\code{\link{cpm}}, \code{\link{rcp}}, \code{\link{ppersist}}
}
