% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chat.recent.R
\name{chat.recent}
\alias{chat.recent}
\title{Retrieve the latest message from the chat history of a Generative AI model}
\usage{
chat.recent(model.parameter, history)
}
\arguments{
\item{model.parameter}{A character vector containing essential information about the
Generative AI service provider, model, version, API key, and proxy status.}

\item{history}{A list containing all messages exchanged between the user and the model in a chat session.}
}
\value{
If successful, the function returns the latest message in the chat history. In case of
incorrect input format, the function halts execution and provides an error message.
}
\description{
This function fetches the most recent message in the chat history of a Generative AI model.
}
\details{
Providing accurate and valid information for each parameter is crucial for successful
text generation by the Generative AI model. This function modifies the chat history. If any
parameter is incorrect, the function responds with an error message based on the API feedback.
To view all supported Generative AI models, use the function \code{\link{available.models}}.
Additionally, utilize \code{\link{chat.setup}} to set up a chat history.
}
\examples{
\dontrun{
 # Get available models
 models = available.models()

 # Connect to the model, replace API_KEY with your api key
 google.model = connect.genai("google",
                              models$google$model[1],
                              models$google$version[1],
                              "API_KEY",
                              FALSE)

 # Connect to the model, replace API_KEY with your api key
 openai.model = connect.genai("openai",
                              models$openai$model[1],
                              models$openai$version[1],
                              "API_KEY",
                              FALSE)
 # Setup an empty chat history
 google.history = chat.setup(google.model)
 openai.history = chat.setup(openai.model)

 # Start chat
 temperature = 0.9
 prompt = "Write a story about a magic backpack in about 100 words."
 google.history = chat(google.model,
                       temperature,
                       google.history,
                       prompt)

 # Get the most recent message generated by the model
 cat(chat.recent(google.model, google.history))

 openai.history = chat(openai.model,
                       temperature,
                       openai.history,
                       prompt)

 # Get the most recent message generated by the model
 cat(chat.recent(openai.model, openai.history))

 prompt = "What is the word count of the story you just wrote?"
 google.history = chat(google.model,
                       temperature,
                       google.history,
                       prompt)

 # Get the most recent message generated by the model
 cat(chat.recent(google.model, google.history))

 openai.history = chat(openai.model,
                       temperature,
                       openai.history,
                       prompt)

 # Get the most recent message generated by the model
 cat(chat.recent(openai.model, openai.history))
}

}
\seealso{
\href{https://genai.gd.edu.kg/r/documentation/}{GenAI - R Documentation}
}
