% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_instances.R
\name{create_B}
\alias{create_B}
\title{Create tumor phylogenetic tree topology}
\usage{
create_B(n, k)
}
\arguments{
\item{n}{An integer representing the number of nodes in the phylogenetic tree.}

\item{k}{A numeric value representing the constant used to calculate the probability of a node to be chosen as a parent of a new node.}
}
\value{
A square matrix representing the mutation relationships between the nodes in the phylogenetic tree. Each row corresponds to a node, and each column corresponds to a mutation. The value at the i-th row and j-th column is 1 if the i-th node has the j-th mutation, and 0 otherwise.
}
\description{
This function generates a mutation matrix (B matrix) for a tumor phylogenetic tree with a given number of nodes. This matrix represents the topology and it is created randomly, with the probability of a node to be chosen as a parent of a new node being proportional to the number of its ascendants raised to the power of a constant `k`.
}
\examples{

# Create a mutation matrix for a phylogenetic tree with 10 nodes and k = 2
B <- create_B(10, 2)

}
