% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gravity.es.R
\name{gravity.es}
\alias{gravity.es}
\title{Effect Size}
\usage{
gravity.es(x, actual.n = FALSE, alpha = 0.95)
}
\arguments{
\item{x}{gravity model object}

\item{actual.n}{(FALSE/TRUE) Use actual N or degrees of freedom 
in calculating Confidence Interval}

\item{alpha}{confidence interval}
}
\value{
data.frame of parameter effect size
}
\description{
Cohen's D effect size for gravity models
}
\details{
Calculate Cohen's D statistic for each effect in a gravity model object
}
\examples{
 
library(nlme)
  data(ralu.model)

x = c("DEPTH_F", "HLI_F", "CTI_F", "cti", "ffp")
gm_h1 <- gravity(y = "DPS", x = x, d = "DISTANCE", group = "FROM_SITE", 
                data = ralu.model, ln = FALSE, method="ML") 

gravity.es(gm_h1)

}
\references{
Murphy M.A., R. Dezzani, D.S. Pilliod & A.S. Storfer (2010) Landscape genetics of 
  high mountain frog metapopulations. Molecular Ecology 19(17):3634-3649

Cohen, J. (1988) Statistical power for the behavioral sciences (2nd ed.). 
  Hillsdale, NJ: Erlbaum
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org> and 
        Melanie Murphy <melanie.murphy@uwyo.edu>
}
