% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flow.R
\name{flow}
\alias{flow}
\title{Convert distance to flow}
\usage{
flow(x, standardize = FALSE, rm.na = FALSE, diag.value = NA)
}
\arguments{
\item{x}{A numeric vector or matrix object representing distances}

\item{standardize}{(FALSE/TRUE) Row-standardize the data before calculating flow}

\item{rm.na}{(TRUE/FALSE) Should NA's be removed, if FALSE (default) the 
will be retained in the results}

\item{diag.value}{If x is a matrix, what diagonal matrix values should be 
used (default is NA)}
}
\value{
A vector or matrix representing flow values
}
\description{
Converts distance to flow (1-d) with or without data standardization
}
\examples{
#### On a distance vector
flow(runif(10,0,1))
flow(runif(10,0,500), standardize = TRUE)

# With NA's
d <- runif(10, 0,1)
  d[2] <- NA
flow(d)
flow(d, rm.na=TRUE)

#### On a distance matrix
dm <- as.matrix(dist(runif(5,0,1), diag = TRUE, upper = TRUE))
flow(dm)

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org> and 
        Melanie Murphy <melanie.murphy@uwyo.edu>
}
