% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.node.data.R
\name{build.node.data}
\alias{build.node.data}
\title{Build node data}
\usage{
build.node.data(x, group.ids, from.parms, to.parms = NULL)
}
\arguments{
\item{x}{A data.frame containing node (site) data}

\item{group.ids}{Character vector of unique identifier that can be used to join 
to graph}

\item{from.parms}{Character vector of independent "from" variables}

\item{to.parms}{Character vector of independent "to" variables. If NULL is 
the same as from.parms}
}
\value{
data.frame
}
\description{
Helper function to build the origin/destination node data structure.
}
\note{
Unless a different set of parameters will be used as the destination (to) there 
is no need to define the argument "to.parms" and the "from.parm" will be used to 
define both set of parameters.

The resulting data.frame represents the origin (from) and destination (to) data 
structure for use in gravity model. This is node structure is also know in the 
gravity literature as producer (from) and attractor (to).
}
\examples{
data(ralu.site)

# Build from/to site (node) level data structure 
site.parms = c("AREA_m2", "PERI_m", "Depth_m", "TDS")
site <- build.node.data(ralu.site@data, group.ids = c("SiteName"), 
                        from.parms = site.parms ) 
 
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org> and 
        Melanie Murphy <melanie.murphy@uwyo.edu>
}
