% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DominanceRule.R
\name{DominanceRule}
\alias{DominanceRule}
\title{Dominance \verb{(n,k)} rule for magnitude tables}
\usage{
DominanceRule(
  data,
  x,
  crossTable,
  numVar,
  n,
  k,
  protectZeros = FALSE,
  charVar,
  ...
)
}
\arguments{
\item{data}{the dataset}

\item{x}{ModelMatrix generated by parent function}

\item{crossTable}{crossTable generated by parent function}

\item{numVar}{vector containing numeric values in the data set}

\item{n}{parameter \code{n} in dominance rule.}

\item{k}{parameter \code{k} in dominance rule.}

\item{protectZeros}{parameter determining whether cells with value 0 should be suppressed.}

\item{charVar}{Variable in data holding grouping information. Dominance will be calculated after aggregation within these groups.}

\item{...}{unused parameters}
}
\value{
logical vector that is \code{TRUE} in positions corresponding to cells breaching the dominance rules.
}
\description{
Supports application of multiple values for \code{n} and \code{k}. The function works on magnitude tables containing negative cell values by calculating contribution based on absolute values.
}
\details{
This methodn only supports suppressing a single numeric variable.
}
\author{
Daniel Lupp
}
