% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GauPro.R
\docType{class}
\name{GauPro}
\alias{GauPro}
\title{Class providing object with methods for fitting a GP model}
\format{\code{\link{R6Class}} object.}
\usage{
GauPro
}
\value{
Object of \code{\link{R6Class}} with methods for fitting GP model.
}
\description{
Class providing object with methods for fitting a GP model
}
\section{Fields}{

\describe{
\item{\code{X}}{Design matrix}

\item{\code{Z}}{Responses}

\item{\code{N}}{Number of data points}

\item{\code{D}}{Dimension of data}

\item{\code{corr}}{Type of correlation function}

\item{\code{nug.min}}{Minimum value of nugget}

\item{\code{nug}}{Value of the nugget, is estimated unless told otherwise}

\item{\code{theta}}{Length-scale parameters}

\item{\code{separable}}{Are the dimensions separable?}

\item{\code{verbose}}{0 means nothing printed, 1 prints some, 2 prints most.}

\item{\code{useGrad}}{Should grad be used?}

\item{\code{useC}}{Should C code be used?}

\item{\code{parallel}}{Should the code be run in parallel?}

\item{\code{parallel.cores}}{How many cores are there? It will self detect, do not set yourself.}
}}
\section{Methods}{

\describe{
  \item{Documentation}{For full documentation of each method go to https://github.com/lightning-viz/lightining-r/}
  \item{\code{new(X, Z, corr="Gauss", verbose=0, separable=T, useC=F,useGrad=T,
         parallel=T, useOptim2=T, nug.est=T, ...)}}{This method is used to create object of this class with \code{X} and \code{Z} as the data.}

  \item{\code{update(Xnew=NULL, Znew=NULL, Xall=NULL, Zall=NULL,
restarts = 5, useOptim2=self$useOptim2,
theta.update = T, nug.update = self$nug.est)}}{This method updates the model, adding new data if given, then running optimization again.}
  }
}
\examples{
n <- 12
x <- matrix(seq(0,1,length.out = n), ncol=1)
y <- sin(2*pi*x) + rnorm(n,0,1e-1)
gp <- GauPro$new(X=x, Z=y, parallel=FALSE)
}
\keyword{Gaussian}
\keyword{data,}
\keyword{kriging,}
\keyword{process,}
\keyword{regression}

