% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fit.R
\name{Fit}
\alias{Fit}
\title{Fit a GaSP model.}
\usage{
Fit(
  x,
  y,
  reg_model,
  sp_model = NULL,
  cor_family = c("PowerExponential", "Matern"),
  cor_par = data.frame(0),
  random_error = c(FALSE, TRUE),
  sp_var = -1,
  error_var = -1,
  nugget = 1e-09,
  tries = 10,
  seed = 500,
  fit_objective = c("Likelihood", "Posterior"),
  theta_standardized_min = 0,
  theta_standardized_max = .Machine$double.xmax,
  alpha_min = 0,
  alpha_max = 1,
  derivatives_min = 0,
  derivatives_max = 3,
  log_obj_tol = 1e-05,
  log_obj_diff = 0,
  lambda_prior = 0.1,
  model_comparison = c("Objective", "CV")
)
}
\arguments{
\item{x}{A data frame containing the input (explanatory variable) training data.}

\item{y}{A vector or a data frame with one column
containing the output (response) training data.}

\item{reg_model}{The regression model, specified as a formula,
but note the left-hand side of the formula is unused; see example.}

\item{sp_model}{An optional stochastic process model, specified as a formula,
but note the left-hand side of the formula and the intercept are unused.
The default \code{NULL} uses all column names in \code{x}.}

\item{cor_family}{A character string specifying the
(product, anisoptropic) correlation-function family:
"PowerExponential" for the power-exponential family
or "Matern" for the Matern family.}

\item{cor_par}{An optional data frame containing the correlation parameters
with one row per \code{sp_model} term and two columns set up as
described in \code{\link{GaSPModel}} Details;
only used to start the first objective maximization (see Details).}

\item{random_error}{A boolean for the presence or not of a
random (measurement, white-noise) error term.}

\item{sp_var, error_var}{The stochastic process and error variances;
legal values are only used if \code{random_error = TRUE}
to start the first objective maximization (see Details).}

\item{nugget}{For numerical stability the proportion of the total variance
due to random error is fixed at this value (\code{random_error = FALSE}) or
bounded below by it (\code{random_error = TRUE}).}

\item{tries}{Number of optimizations of the objective from different random
starting points.}

\item{seed}{The random-number seed to generate starting points.}

\item{fit_objective}{The objective that \code{Fit} attempts to maximize:
"Likelihood" (maximum likelihood estimation)
or "Posterior" (Bayesian maximum a posteriori estimation).}

\item{theta_standardized_min, theta_standardized_max}{The minimum and maximum of the standardized \eqn{\theta} parameter (see Details).}

\item{alpha_min, alpha_max}{The minimum and maximum
of the \eqn{\alpha} parameter of power-exponential.}

\item{derivatives_min, derivatives_max}{The minimum and maximum
of the \eqn{\delta} parameter of Matern.}

\item{log_obj_tol}{An absolute tolerance for terminating the maximization
of the log of the objective.}

\item{log_obj_diff}{The critical value for the change in the log objective
for informal tests during optimization of correlation parameters.
No testing is done with the default of 0;
a larger critical value such as 2 may give a more parsimonious model.}

\item{lambda_prior}{The rate parameter of an exponential prior
for each \eqn{\theta} parameter;
used only if \code{fit_objective = "Posterior"}.}

\item{model_comparison}{The criterion used to select from multiple solutions
when \eqn{\code{tries} > 1}: the objective function ("Objective")
or leave-one-out cross validation ("CV").}
}
\value{
A \code{GaSPModel} object, which is a list with the following components:
\item{x}{The data frame containing the input training data.}
\item{y}{The training output data, now as a vector.}
\item{reg_model}{The regression model, now in the form of a data frame.}
\item{sp_model}{The stochastic process model, now in the form of a data frame.}
\item{cor_family}{The correlation family.}
\item{cor_par}{A data frame for the estimated correlation parameters.}
\item{random_error}{The boolean for the presence or not of a random error term.}
\item{sp_var}{The estimated stochastic process variance.}
\item{error_var}{The estimated random error variance.}
\item{beta}{A data frame holding the estimated regression-model parameters.}
\item{objective}{The maximum value found for the objective function:
the log likelihood (fit_objective = "Likelihood")
or the log posterior (fit_objective = "Posterior").}
\item{cond_num}{The condition number.}
\item{CVRMSE}{The leave-one-out cross-validation root mean squared error.}
}
\description{
Fit (train) a GaSP model.
}
\details{
Fit numerically maximizes the profile objective function
with respect to the correlation parameters;
the mean and overall variance parameters are estimated in closed form
given the correlation parameters.

A \code{cor_par} data frame supplied by the user is the starting point
for the first optimization try.
If \code{random_error = TRUE},
then \code{sp_var} / (\code{sp_var} + \code{error_var}) is another
correlation parameter to be optimized;
\code{sp_var} and \code{error_var} values supplied by the user
will initialize this parameter for the first try.

Set \code{random_error = TRUE} to estimate the variance of the
random (measurement, white-noise) error;
a small \code{nugget} error variance is for numerical stability.

For term \eqn{j} in the stochastic-process model,
the estimate of \eqn{\theta_j} is constrained between
\code{theta_standardized_min} / \eqn{r_j^2} and
\code{theta_standardized_max} / \eqn{r_j^2},
where \eqn{r_j} is the range of term \eqn{j}.
Note that \code{Fit} returns unscaled estimates relating to the original, unscaled inputs.
}
\examples{
x <- borehole$x
y <- borehole$y
borehole_fit <- Fit(
  reg_model = ~1, x = x, y = y, cor_family = "Matern",
  random_error = FALSE, nugget = 0, fit_objective = "Posterior"
)
}
\references{
Sacks, J., Welch, W.J., Mitchell, T.J., and Wynn, H.P. (1989)
"Design and Analysis of Computer Experiments", \emph{Statistical Science}, 4, pp. 409-423,
doi:10.1214/ss/1177012413.
}
