% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createOptions.R
\name{createOptions}
\alias{createOptions}
\title{Create a list with default start options.}
\usage{
createOptions(site_name = NULL)
}
\arguments{
\item{site_name}{An arbitrary string containing the name of the monitoring site.}
}
\value{
A list containing essential model parameters and start options.
}
\description{
\code{createOptions} creates a list with start options that can be modified 
and passed as argument to \code{\link{launchApp}}.
}
\examples{
opt <- createOptions("New Site 1")
opt$PSplineVars$nseg <- 10  # modify model parameter for p-splines.
opt$WellDataFilename <- 'path_to_concentration_file.csv'
opt$WellCoordsFilename <- 'path_to_well_coordinate_file.csv'
if(interactive()) {
launchApp(opt)
}
}
