% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manh_plot.R
\name{manhattan.plot}
\alias{manhattan.plot}
\title{Creates the Manhattan plot}
\usage{
manhattan.plot(
  dataset,
  chr,
  pvalue,
  position,
  fileName,
  plot.title = "Manhattan Plot",
  plot.subtitle = "",
  p.threshold = 0.01,
  sig.threshold.log = -log10(5 * 10^-8),
  beta = NULL,
  std.error = NULL,
  check.columns = TRUE
)
}
\arguments{
\item{dataset}{Data frame or data table containing the below columns}

\item{chr}{Name of chromosome column}

\item{pvalue}{Name of P-value column}

\item{position}{Name of position column}

\item{fileName}{Full name and path of file to be saved (file extension should be 'png'). e.g. “c:/users/researcher/study/man_plot.png”}

\item{plot.title}{Title of the plot, default value is 'Manhattan plot'}

\item{plot.subtitle}{Subtitle of the plot}

\item{p.threshold}{Threshold for plotting variants (i.e. p-values > 0.01 will not be plotted). Setting a higher threshold will significantly increase plotting time}

\item{sig.threshold.log}{The -log10 transformed significance threshold, used for plotting a threshold line (e.g. 8 = 10^-8)}

\item{beta}{(optional) Name of the effect-size column}

\item{std.error}{(optional) Name of the standard error column}

\item{check.columns}{Whether to check input columns for invalid values}
}
\value{
Generates and saves a Manhattan plot for the provided data.
}
\description{
A function to generate Manhattan plots.
}
\examples{
input.data = read.table(gzfile(system.file("extdata", "demo.txt.gz", package = "GWASinspector")),
                        header = TRUE,
                        stringsAsFactors = FALSE,
                        fill = TRUE)
tmpPlotFile = paste(tempfile(),'png',sep = '.')
manhattan.plot(dataset = input.data, chr = 'CHR', pvalue = 'PVALUE', position = 'POSITION',
         plot.title = 'Manhattan plot', plot.subtitle = 'This data is fabricated!',
         fileName = tmpPlotFile , p.threshold = '0.5')

}
