% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_inventory.R
\name{get_inventory}
\alias{get_inventory}
\title{Download and Return a Tidy Data Frame of \acronym{GSOD} Weather Station Data Inventories}
\usage{
get_inventory()
}
\value{
A data frame as a \code{\link[tibble]{tibble}} object of station
inventories
}
\description{
The \acronym{NCEI} maintains a document,
\url{ftp://ftp.ncdc.noaa.gov/pub/data/noaa/isd-inventory.txt}, which lists
the number of weather observations by station-year-month from the beginning
of the stations' records.  This function retrieves that document and prints
an information header displaying the last update time with a data frame of
the inventory information for each station-year-month.
}
\note{
The \acronym{GSOD} data, which are downloaded and manipulated by
\pkg{GSODR}, stipulate that the following notice should be given.
\dQuote{The following data and products may have conditions placed on their
international commercial use.  They can be used within the U.S. or for non-
commercial international activities without restriction.  The non-U.S. data
cannot be redistributed for commercial purposes.  Re-distribution of these
data by others must provide this same notification.}

The download process can take quite some time to complete.
}
\examples{
\donttest{
inventory <- get_inventory()
inventory
}
}
\author{
Adam H Sparks, \email{adamhsparks@gmail.com}
}
