% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_david_data_file.R
\name{extract_david_GSC}
\alias{extract_david_GSC}
\title{extract_david_GSC}
\usage{
extract_david_GSC(
  data,
  genes.field = "Genes",
  term.field = "Term",
  del = "\\\\s*,\\\\s*"
)
}
\arguments{
\item{data}{A data.frame containing DAVID pathways data (without duplicates).}

\item{genes.field}{The name of the field containing the lists of genes for each gene set (default: \code{"Genes"}).}

\item{term.field}{The name of the field containing the ID for each gene set (default: \code{"Term"}).}

\item{del}{A pattern specifying the delimiter for the genes in \code{genes.field}. (default: \code{"\\\\s*,\\\\s*"})}
}
\value{
A gene set collection as a list of gene set vectors, where the gene set names correspond to Terms and
the vectors contain gene symbols corresponding to the genes listed in \code{genes.field}.
}
\description{
extract_david_GSC
}
\seealso{
\itemize{
\item \code{\link{gsnAddPathwaysData}()}
\item \code{\link{read_david_data_file}()}
}
}
