% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{lfisher_cpp}
\alias{lfisher_cpp}
\title{lfisher_cpp}
\usage{
lfisher_cpp(a, b, c, d, e_precision = 12, alternative = 1L)
}
\arguments{
\item{a}{(required) This corresponds to cell 1 of the contingency matrix. In the context of GSNA, assuming two gene
sets, this is used as the number of observable genes in the background that are not present either gene set.}

\item{b}{(required) This corresponds to cell 2 of the contingency matrix. For GSNA this is the number of observable
genes present in gene set 1, but not gene set 2.}

\item{c}{(required) This corresponds to cell 3 of the contingency matrix. For GSNA this is the number of observable
genes present in gene set 2, but not gene set 1.}

\item{d}{(required) This corresponds to cell 4 of the contingency matrix. For GSNA this is the number of observable
genes present in both gene sets 1 and 2.}

\item{e_precision}{(optional) Numeric value that determines the precision of summation of partial \emph{p}-values. For
the less-than, greater-than and two-sided options in calculating the log-Fisher \emph{p}-value, log-space summation of
partial \emph{p}-values must be accomplished using the so-called \emph{Log-Sum-Exponent} trick. Due to limitations of precision
in C++, however, numbers that differ by more than about 11 powers of \emph{e} cannot be summed. By specifying a value less
than 12, slightly less precise p-values can be calculated slightly faster. This option was included as way to
accelerate calculation of \emph{p}-values, but has not proven to significantly improve performance, so it may be removed
in the future. Defaults to 12.}

\item{alternative}{(optional) Integer corresponding to 4 options:
\describe{
\item{\code{1}}{single-sided, greater-than. Sums \emph{p}-values for intersections greater than and equal to \code{d}.}
\item{\code{2}}{single-sided, less-than. Sums \emph{p}-values for intersections less than and equal to \code{d}.}
\item{\code{3}}{two-sided, sums all partial \emph{p}-values less than or equal to the partial \emph{p}-value for intersections
equal to \code{d}.}
\item{\code{4}}{partial. Calculates single \emph{p}-value for intersections equal to \code{d}.}
}}
}
\value{
This function returns a numeric (double in C++) natural log-Fisher p-value.
}
\description{
Takes a four integers corresponding to a 2x2 contingency matrix and calculates a natural-log transformed
Fisher \emph{p}-value.
}
\details{
Calculation of Fisher \emph{p}-values is discussed in detail elsewhere, but partial natural-log
transformed \emph{p}-values are calculated as follows:

Given a 2x2 contingency matrix of the form:

\deqn{\biggl[\begin{matrix}a & b \\ c & d\end{matrix}\biggr]}

The natural log of the partial \emph{p}-values is given by:

\deqn{ln(p)  = ln((a+b)!) + ln((c+d)!) +
               ln((a+c)!) + ln((b+d)!) -
               ln(a!) - ln(b!) - ln(c!) -
               ln(d!) - ln((a + b + c + d)!)}

For the single and two-tailed alternatives, partial \emph{p}-values are summed using the so-called 'log-sum-exponent' method.
}
\examples{

library(GSNA)

# Calculate a single natural log Fisher_p value:
log_fisher_p <- lfisher_cpp( a = 16000,
                             b = 200,
                             c = 170,
                             d = 100,
                             alternative = 3 )


}
\seealso{
\code{\link{gsIntersectCounts}}
\code{\link{scoreLFMatrix_C}}
}
