% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/locateRisk.R
\name{buildRiskReport}
\alias{buildRiskReport}
\title{Build risk-assessment for proposed package updates}
\usage{
buildRiskReport(to_update = old.packages(repos = repo_urls),
  important_pkgs = installed.packages(lib.loc = liblocs)[, "Package"],
  liblocs = .libPaths(), repo_urls = getOption("repos"),
  file = "update-risk.html")
}
\arguments{
\item{to_update}{vector of package names which may be updated, or a matrix output from \code{old.packages}. Defaults to all packages which are out of date}

\item{important_pkgs}{list of packages to check for risk of change cascades from updating the packages in \code{to_update}. Defaults to all installed packages}

\item{liblocs}{the library locations to look for installed packages}

\item{repo_urls}{The repositories to check for new versions of packages}

\item{file}{file to write the resulting HTML report into.}
}
\value{
the
}
\description{
buildRiskReport
}
\details{
Generates an HTML report identifying which packages have updates available, and which of the specified important packages may be effected by installing those new versions.
}

