% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoGPoMoSearch.R
\name{autoGPoMoSearch}
\alias{autoGPoMoSearch}
\title{autoGPoMoSearch : automatic search of polynomial Equations}
\usage{
autoGPoMoSearch(data, dt, nVar = nVar, dMax = dMax, weight = NULL,
  show = 0, underSamp = NULL, filterReg = NULL)
}
\arguments{
\item{data}{Input Time series: Each column corresponds to one input variable.}

\item{dt}{Time sampling of the input series.}

\item{nVar}{The model dimension expected. This parameter will be
deduced from the input data (\code{series}) if \code{series} is
a matrix. If \code{series} is a vector, the expected dimension nVar
should be provided.}

\item{dMax}{Maximum degree of the polynomial functions allowed
in the model (see \code{poLabs}).}

\item{weight}{Weighting function of input data series. By default uniform
weight is applied. This weighting function can also be used to apply
the analysis piecewise using zeros and ones.}

\item{show}{Indicates (2) or not (0-1) the algorithm progress}

\item{underSamp}{Points used for undersampling the data. For undersamp = 1
the complete time series is used. For undersamp = 2, only one data out of
two is kept, etc.}

\item{filterReg}{A vector that specifies the a priori structure of
the the function of the output model in canonical form.
The organisation of the filter follows the convention defined in
\code{poLabs} and can be obtained using \code{poLabs(nVar,dMax)}.
Value is 1 if the regressor is available, 0 if it is not.}
}
\value{
A list of two matrices:

\code{$filtMemo} describes the selected terms
(1 if the term is used, 0 if not)

\code{$KMemo} provides the correspoing coefficients
}
\description{
The algorithm aims to get an ensemble of equations
to be tested from a given template of allowed terms.
The maximum size of the equation depends on the model dimension nVar,
and on the maximum polynomial degree dMax.
The algorithm remove polynomial terms one by one, considering
that a term is poorly useful when removing it leads to the
smaller fitting degradation.
}
\examples{
data('RosYco')
filt = autoGPoMoSearch(RosYco[,2], nVar = 3, dMax = 2,
                       dt = 1/125, show = 1)
# As an example, the equations of the fourth line has the following terms:
poLabs(nVar = 3, dMax = 2)[filt$filtMemo[5,] != 0]
# which coefficients correspond to
cbind(filt$KMemo[5,], poLabs(nVar = 3, dMax = 2))[filt$filtMemo[5,] != 0,]

}
\author{
Sylvain Mangiarotti, Flavie Le Jean
}

