% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpfr.functions6.R
\name{mat2fd}
\alias{mat2fd}
\title{Create an 'fd' object from a matrix}
\usage{
mat2fd(mat, fdList = NULL)
}
\arguments{
\item{mat}{Input data, should be a matrix with ncol time points and nrow
replications or samples.}

\item{fdList}{A list with following items: \describe{ \item{time}{Sequence
of time points (default to be 100 points from 0 to 1).}
\item{nbasis}{Number of basis functions used in smoothing, default to be
less or equal to 23.} \item{norder}{Order of the functional curves default
to be 6.} \item{bSpline}{Logical, if TRUE (default), b-Spline basis is
used; otherwise, Fourier basis is used.} \item{Pen}{Default to be c(0,0),
meaning that the penalty is on the second order derivative of the curve,
since the weight for zero-th and first order derivatives of the curve are
set to zero.} \item{lambda}{Smoothing parameter for the penalty. Default to
be 1e-4.} }}
}
\value{
An 'fd' object
}
\description{
Easy setting up for creating an 'fd' object
}
\details{
All items listed above have default values. If any item is required
  to change, add that item into the list; otherwise, leave it as NULL. For
  example, if one only wants to change the number of basis functions, do:
  
  \code{mat2fd(SomeMatrix,list(nbasis=21))}
}
\examples{
require(fda)
require(fda.usc)
nrep <- 20   # number of replications
n <- 100     # number of time points
input <- seq(-1, pi, length.out=n) # time points
ry <- rnorm(nrep, sd=10)
y <- matrix(NA, ncol=n, nrow=nrep)
for(i in 1:nrep)  y[i,] <- sin(2*input)*ry[i]

plot.fdata(fdata(y,input))

yfd <- mat2fd(y, list(lambda=0.01))
plot(yfd)

yfd <- mat2fd(y, list(lambda=0.00001))
plot(yfd)

}
\references{
Ramsay, J., and Silverman, B. W. (2006),
}
