% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_synthetic_data.R
\name{generate_synthetic_data}
\alias{generate_synthetic_data}
\title{Generate synthetic data for GPCERF package}
\usage{
generate_synthetic_data(
  sample_size = 1000,
  outcome_sd = 10,
  gps_spec = 1,
  cova_spec = 1
)
}
\arguments{
\item{sample_size}{A number of data samples.}

\item{outcome_sd}{Standard deviation used to generate the outcome in the
synthetic data set.}

\item{gps_spec}{A numeric value (1-6) that indicates the GPS model used to
generate the continuous exposure.}

\item{cova_spec}{A numeric value (1-2) to modify the covariates.}
}
\value{
A data frame of the synthetic data. Outcome is labeled as Y, exposure as w,
and covariates cf1-6.
}
\description{
Generates synthetic data set based on different GPS models and covariates.
}
\examples{

set.seed(351)
data <- generate_synthetic_data(sample_size = 200)

}
