% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degreeDistMF.R
\name{GOTermMF2ChildLevel}
\alias{GOTermMF2ChildLevel}
\title{Get the level of a molecular function (MF) GO term's children}
\usage{
GOTermMF2ChildLevel(goterm)
}
\arguments{
\item{goterm}{A character string of a valid gene ontology id e.g "GO:0004518"}
}
\value{
A list of children terms and their respective levels
}
\description{
This function retrieves a GO MF term children's level i.e. for a GO-term it's children level are derived.
}
\examples{
# Retrieve "GO:0000978" children's level
GOTermMF2ChildLevel(goterm = "GO:0000978")

# Retrieve "GO:0004518" children's level
GOTermMF2ChildLevel(goterm = "GO:0004518")

}
