% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptod.R
\name{Phase.to.disp}
\alias{Phase.to.disp}
\title{InSAR Unw-Phase to displacement}
\usage{
Phase.to.disp(unw_phase, wavelength = "in meter", unit = "m", inc_ang = 0)
}
\arguments{
\item{unw_phase}{Un-wrapped InSAR tile/raster.After/before correction.}

\item{wavelength}{SAR wavelength in meter.}

\item{unit}{output unit meter , centimeter or milimeter ("m", "cm" or "mm").}

\item{inc_ang}{SAR incident angle (to get output in LOS direction, don't use if not needed).}
}
\description{
InSAR Unw-Phase to displacement
}
\examples{
library(raster)
library(GInSARCorW)
library(circular)
noDataAsNA<-FALSE
i1m<-system.file("td","20170317.ztd.rsc",package = "GInSARCorW")
i2m<-system.file("td","20170410.ztd.rsc",package = "GInSARCorW")
GACOS_ZTD_T1<-GACOS.Import(i1m,noDataAsNA)
GACOS_ZTD_T2<-GACOS.Import(i2m,noDataAsNA)
dztd<-d.ztd(GACOS_ZTD_T1,GACOS_ZTD_T2)
unw_pha<-raster(system.file("td","Unw_Phase_ifg_17Mar2017_10Apr2017_VV.img",package = "GInSARCorW"))
crs(unw_pha)<-CRS("+proj=longlat +datum=WGS84 +no_defs")
re_dztd<-d.ztd.resample(unw_pha,dztd)
unw_phase<-GACOS.PhCor(unw_pha,re_dztd,0.055463,inc_ang=39.16362,ref_lat=NA,ref_lon=NA)
Phase.to.disp(unw_phase,0.055463,unit="m",39.16362)
}
\author{
Subhadip Datta
}
