% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIFT_richness.R
\name{GIFT_richness}
\alias{GIFT_richness}
\title{Species richness per geographic region and taxonomic group in GIFT}
\usage{
GIFT_richness(
  taxon_name = "Embryophyta",
  GIFT_version = "latest",
  api = "https://gift.uni-goettingen.de/api/extended/"
)
}
\arguments{
\item{taxon_name}{Taxonomic group to retrieve species richness for.}

\item{GIFT_version}{character string defining the version of the GIFT
database to use. The function retrieves by default the \code{latest} stable
version. If set to \code{beta}, the most up-to-date version which is still
subject to changes and edits is used.}

\item{api}{character string defining from which API the data will be
retrieved.}
}
\value{
A data frame with species richness values for different floristic
subsets per geographic region in GIFT.
}
\description{
Retrieve species richness of all species, native species, naturalized
species and endemic species per taxonomic group and geographic region
combination.
}
\details{
The output has 5 columns:

\emph{entity_ID} - Identification number of the geographic region\cr
\emph{total} - total species richness\cr
\emph{native} - number of native species\cr
\emph{naturalized} - number of naturalized species\cr
\emph{endemic_min} - number of endemic species

The number of endemic species is a conservative count not counting
occurrences of species which go back to infraspecific taxa.
}
\examples{
\donttest{
ex <- GIFT_richness(taxon_name = "Angiospermae")
}

}
\references{
\if{html}{\out{<div class="sourceCode">}}\preformatted{ Weigelt, P, König, C, Kreft, H. GIFT – A Global Inventory of Floras and
 Traits for macroecology and biogeography. J Biogeogr. 2020; 47: 16– 43.
 https://doi.org/10.1111/jbi.13623
}\if{html}{\out{</div>}}
}
\seealso{
\code{\link[=GIFT_traits_meta]{GIFT_traits_meta()}}
}
