% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIFT_shapes.R
\name{GIFT_shapes}
\alias{GIFT_shapes}
\title{Shape files of GIFT regions}
\usage{
GIFT_shapes(
  entity_ID = NULL,
  api = "https://gift.uni-goettingen.de/api/extended/",
  GIFT_version = "latest"
)
}
\arguments{
\item{entity_ID}{A vector defining the IDs of the regions.}

\item{api}{character string defining from which API the data will be
retrieved.}

\item{GIFT_version}{character string defining the version of the GIFT
database to use. The function retrieves by default the \code{latest} stable
version. If set to \code{beta}, the most up-to-date version which is still
subject to changes and edits is used.}
}
\value{
A spatial data.frame with 13 columns.
}
\description{
Get shapefile of GIFT regions for selected regions.
}
\details{
Here is the detail of each column:

\emph{entity_ID} - Identification number of the polygon\cr
\emph{geo_entity} - Name of the polygon\cr
\emph{point_x} - Longitude of the centroid of the polygon\cr
\emph{point_y} - Latitude of the centroid of the polygon\cr
\emph{area} - Area in km2 of the polygon\cr
\emph{x_min} - Minimum longitude of the polygon\cr
\emph{x_max} - Maximum longitude of the polygon\cr
\emph{y_min} - Minimum latitude of the polygon\cr
\emph{y_max} - Maximum latitude of the polygon\cr
\emph{entity_class} - Class of the polygon\cr
\emph{entity_type} - Type of the entity\cr
\emph{polygon_source} - Source of the polygon\cr
\emph{geometry} - Geometry column from sf
}
\examples{
\donttest{
ex <- GIFT_shapes(entity_ID = c(677, 200))
plot(sf::st_geometry(ex), col = ex$entity_ID)
}

}
\references{
\if{html}{\out{<div class="sourceCode">}}\preformatted{ Weigelt, P, König, C, Kreft, H. GIFT – A Global Inventory of Floras and
 Traits for macroecology and biogeography. J Biogeogr. 2020; 47: 16– 43.
 https://doi.org/10.1111/jbi.13623
}\if{html}{\out{</div>}}
}
\seealso{
\code{\link[=GIFT_env]{GIFT_env()}}
}
