% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggpairs_internal_plots.R
\name{wrap}
\alias{wrap}
\alias{wrap_fn_with_param_arg}
\alias{wrap_fn_with_params}
\alias{wrapp}
\title{Wrap a function with parameters}
\usage{
wrap(funcVal, ..., funcArgName = substitute(funcVal))

wrap_fn_with_params(funcVal, ..., funcArgName = substitute(funcVal))

wrap_fn_with_param_arg(funcVal, params = NULL,
  funcArgName = substitute(funcVal))

wrapp(funcVal, params = NULL, funcArgName = substitute(funcVal))
}
\arguments{
\item{funcVal}{function that the \code{params} will be applied to.  The function should follow the api of \code{function(data, mapping, ...)\{\}}}

\item{...}{named parameters to be supplied to \code{wrap_fn_with_param_arg}}

\item{funcArgName}{name of function to be displayed}

\item{params}{named vector of parameters to be applied to the \code{funcVal}}
}
\value{
a \code{function(data, mapping, ...)\{\}} that will wrap the original function with the parameters applied as arguements
}
\description{
Wraps a function with the given parameters.  This allows for very specific parameter arguements to be applied to each specific function.
}
\details{
\code{wrap == wrap_fn_with_params}

\code{wrapp == wrap_fn_with_param_arg}
}
\examples{
fn <- function(data, mapping, val = 2) {
  print(val)
}
fn(NULL, NULL) # 2
wrapped_fn <- wrap_fn_with_param_arg(fn, params = c(val = 5))
wrapped_fn(NULL, NULL) # 5
}

