% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmncv.R
\name{ggmncv}
\alias{ggmncv}
\title{GGMncv}
\usage{
ggmncv(
  R,
  n,
  penalty = "atan",
  ic = "bic",
  select = "lambda",
  gamma = NULL,
  lambda = NULL,
  n_lambda = 50,
  n_gamma = 50,
  initial = NULL,
  LLA = FALSE,
  unreg = FALSE,
  maxit = 10000,
  thr = 1e-04,
  store = TRUE,
  progress = TRUE,
  ...
)
}
\arguments{
\item{R}{Matrix. A correlation matrix of dimensions \emph{p} by \emph{p}.}

\item{n}{Numeric. The sample size used to compute the information criterion.}

\item{penalty}{Character string. Which penalty should be used (defaults to \code{"atan"})?}

\item{ic}{Character string. Which information criterion should be used (defaults to \code{"bic"})?
The options include \code{aic}, \code{ebic} (ebic_gamma defaults to \code{0.5}; see details),
\code{ric}, or any of the generalized information criteria provided in section 5 of
\insertCite{kim2012consistent;textual}{GGMncv}. The options are \code{gic_1}
(i.e., \code{bic}) to \code{gic_6}.}

\item{select}{Character string. Which tuning parameter should be selected (defaults to \code{"lambda"})?.
The options include \code{"lambda"} (the regularization parameter),
\code{"gamma"} (governs the 'shape'), and \code{"both"}. See details.}

\item{gamma}{Numeric vector. Hyperparameter for the penalty function. Defaults to 3.7 (\code{SCAD}),
2 (\code{MCP}), 0.5 (\code{adapt}), and 0.01 otherwise with \code{select = "lambda"}.}

\item{lambda}{Numeric vector. Regularization parameter. Defaults to \code{NULL} that provides default
values with  \code{select = "lambda"} and \code{sqrt(log(p)/n)} with
\code{select = "gamma"}.}

\item{n_lambda}{Numeric. The number of \mjseqn{\lambda}'s to be evaluated. Defaults to 50.
This is disregarded if custom values are provided in \code{lambda}.}

\item{n_gamma}{Numeric. The number of \mjseqn{\gamma}'s to be evaluated. Defaults to 50.
This is disregarded if custom values are provided in \code{lambda}.}

\item{initial}{Matrix. The initial inverse correlation matrix for computing the penalty
derivative. Defaults to \code{NULL} which uses the inverse of \code{R}.}

\item{LLA}{Logical. Should the local linear approximation be used (default to \code{FALSE})?}

\item{unreg}{Logical. Should the models be refitted (or unregularized) with maximum likelihood
(defaults to \code{FALSE})? Setting to \code{TRUE} results in the approach of
\insertCite{Foygel2010;textual}{GGMncv}, but with the regularization path obtained from
nonconvex regularization, as opposed to the \mjseqn{\ell_1}-penalty.}

\item{maxit}{Numeric. The maximum number of iterations for determining convergence of the LLA
algorithm (defaults to \code{1e4}). Note this can be changed to, say,
\code{2} or \code{3}, which will provide  two and three-step estimators
without convergence check.}

\item{thr}{Numeric. Threshold for determining convergence of the LLA algorithm
(defaults to \code{1.0e-4}).}

\item{store}{Logical. Should all of the fitted models be saved (defaults to \code{TRUE})?.}

\item{progress}{Logical. Should a progress bar be included (defaults to \code{TRUE})?}

\item{...}{Additional arguments. Currently gamma in EBIC (\code{ic = "ebic"}) can be set
with \code{ebic_gamma = 1}.}
}
\value{
An object of class \code{ggmncv}, including:

\itemize{
\item \code{Theta} Inverse covariance matrix
\item \code{Sigma} Covariance matrix
\item \code{P} Weighted adjacency matrix
\item \code{adj} Adjacency matrix
\item \code{lambda} Tuning parameter
\item \code{fit} glasso fitted model (a list)
}
}
\description{
\loadmathjax
Gaussian graphical models with nonconvex regularization. A survey of these approaches is provided
in \insertCite{williams2020beyond;textual}{GGMncv}.
}
\details{
Several of the penalties are (continuous) approximations to the \mjseqn{\ell_0} penalty,
that is, best subset selection. However, the solution does not require enumerating
all possible models which results in a computationally efficient solution.

\strong{L0 Approximations}

\itemize{

\item Atan: \code{penalty = "atan"} \insertCite{wang2016variable}{GGMncv}. This is currently the default.

\item Seamless \mjseqn{\ell_0}: \code{penalty = "selo"} \insertCite{dicker2013variable}{GGMncv}.

\item Exponential: \code{penalty = "exp"}  \insertCite{wang2018variable}{GGMncv}

\item Log: \code{penalty = "log"} \insertCite{mazumder2011sparsenet}{GGMncv}.

\item Sica: \code{penalty = "sica"}  \insertCite{lv2009unified}{GGMncv}

}

\strong{Additional penalties}:

\itemize{

\item SCAD: \code{penalty = "scad"}  \insertCite{fan2001variable}{GGMncv}.

\item MCP: \code{penalty = "mcp"} \insertCite{zhang2010nearly}{GGMncv}.

\item Adaptive lasso (\code{penalty = "adapt"}): Defaults to  \mjseqn{\gamma = 0.5}
 \insertCite{zou2006adaptive}{GGMncv}. Note that for consistency with the
 other penalties, \mjseqn{\gamma \rightarrow 0} provides more penalization and
 \mjseqn{\gamma = 1} results in \mjseqn{\ell_1} regularization.

\item Lasso:  \code{penalty = "lasso"}  \insertCite{tibshirani1996regression}{GGMncv}.

}

\strong{Gamma} (\mjseqn{\gamma}):

The \code{gamma} argument corresponds to additional hyperparameter for each penalty.
The defaults are set to the recommended values from the respective papers.

\strong{LLA}

The local linear approximate is noncovex penalties was described in
\insertCite{fan2009network}{GGMncv}. This is essentially a iteratively reweighted (g)lasso.
Note that by default \code{LLA = FALSE}. This is due to the work
of \insertCite{zou2008one;textual}{GGMncv}, which suggested that, so long as the starting
values are good enough, then a one-step estimator is sufficient. In the case of low-dimensional data,
the sample based inverse covariance matrix is used to compute the penalty.
This is expected to work well, assuming that \mjseqn{n} is sufficiently larger than  \mjseqn{p}.

\strong{EBIC}

When setting \code{ic = "ebic"}  the hyperparameter that determines the additional penalty to BIC is
passed via the \code{...} argument. This must be specified as \code{ebic_gamma = 1}. The  default is
\code{0.5}.
}
\examples{
# data
Y <- GGMncv::ptsd[,1:10]

S <- cor(Y)

# fit model
fit <- ggmncv(S, n = nrow(Y))

# plot
qgraph::qgraph(fit$P)
}
\references{
\insertAllCited{}
}
