% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_set.r
\name{create_image_set}
\alias{create_image_set}
\title{Create an image set out of a list in the right form.}
\usage{
create_image_set(image_set, ...)
}
\arguments{
\item{image_set}{A list containing elements \code{r}, \code{obs}, \code{sim_m} and \code{theo}.
\code{r}, \code{sim_m} and \code{theo} are optional, \code{obs} needs to be provided always.
\code{r} must be a list of two vectors describing the argument values where
images have been observed (or simulated).
r[[1]] should give the argument values for x-coordinate (first dimension of the 2d functions).
r[[2]] should give the argument values for y-coordinate (second dimension of the 2d functions).
If not given, r is set to be a list of values from 1 to the number of first/second dimension
of 2d functions in \code{obs}.
\code{obs} must be either a 2d matrix (dimensions matching the lengths of r vectors)
or 3d array containing the observed 2d functions (the third dimension matching the number
of functions).
If \code{obs} is a 3d array, then \code{sim_m} is ignored.
If \code{obs} is a 2d array, then \code{sim_m} must be a 3d array containing the simulated
images (2d functions) (the third dimension matching the number of functions).
If included, \code{theo} corresponds to the theoretical function
(e.g., under the null hypothesis) and its dimensions must either match the dimensions
of 2d functions in \code{obs} or it must be a constant.}

\item{...}{Do not use. (For internal use only.)}
}
\value{
The given list adorned with the proper class name.
}
\description{
Create an image set out of a list in the right form containing the values of the 2d functions.
Only 2d functions in a rectangular windows are currently supported; the values are provided
in matrices (arrays).
}
