% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualisation.R
\name{plotSegmentSphere}
\alias{plotSegmentSphere}
\title{Create a spherical representation}
\usage{
plotSegmentSphere(segmentationCSV, plotRows, levels = c(0.9, 0.75, 0.5,
  0.25, 0.1), singlePlot = TRUE, col = heat.colors(5),
  alpha = c(0.03, 0.05, 0.1, 0.2, 0.3), arrow = FALSE, nsims = 1000)
}
\arguments{
\item{segmentationCSV}{The file path to the csv file created from the segmentation process containing all features.}

\item{plotRows}{The rows from the csv file to be used to simulate plotting data.}

\item{levels}{breakpoints for plotting density.}

\item{singlePlot}{(logical) Indicates wether all rows should be added to one plot.}

\item{col}{A vector of colours.}

\item{alpha}{The range of alpha values to be used for plotting colours}

\item{arrow}{(logical) Indicates whether an arrow for directionality should be added to the plot.}

\item{nsims}{The number of simulated values to plot. (Default = 1000 however, if your computer has little RAM reduce this)}
}
\value{
There is no return to the console. As a side effect an rgl graphic is created.
}
\description{
From the segmentation features simulate data and create a spherical representation
}
\details{
This function takes the features from the segmentation procedure and uses them to simulate data for
elevation and rotation. This data is then rotated to give the spherical representation which is ploted on the sphere.
Required columns are:\enumerate{
    \item UpDown.median
    \item UpDown.mad
    \item Degrees.median
    \item Degrees.mad
}
}
\examples{
\dontrun{
segmentationCSV = system.file("data", "SegData.csv", package = "GENEAsphere")
plotRows = c(1:1)
plotSegmentSphere(segmentationCSV, plotRows, levels = c(0.9, 0.75, 0.5, 0.25, 0.1),
                  singlePlot = TRUE, col = heat.colors(5),
                  alpha = c(0.03, 0.05, 0.1, 0.2, 0.3), arrow = FALSE, nsims = 1000)}
}
